/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class DecoderIdAddressData {
    private final byte[] didAddress;

    public DecoderIdAddressData(byte[] didAddress) {
        if (didAddress == null || didAddress.length != 6) {
            throw new IllegalArgumentException("The didAddress is mandatory and must have a length of 6 bytes.");
        }
        this.didAddress = didAddress;
    }

    public DecoderIdAddressData(Long decoderMun, Integer decoderMid) {
        if (decoderMun == null || decoderMid == null) {
            throw new IllegalArgumentException("The decoderMun and decoderMid is mandatory!");
        }
        long decMun = decoderMun;
        int decMid = decoderMid;
        byte[] munBytes = ByteUtils.toDWORD(decMun);
        byte[] midBytes = ByteUtils.toWORD(decMid);
        this.didAddress = ByteUtils.concat(munBytes, midBytes);
    }

    public byte[] getDidAddress() {
        return this.didAddress;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[didAddress=" + ByteUtils.didToHex(this.didAddress) + "]";
    }

    public static String getFormattedDecoderUniqueId(DecoderIdAddressData decoderUniqueId) {
        if (decoderUniqueId != null) {
            return String.format("%04X %08X", decoderUniqueId.getManufacturedId(), decoderUniqueId.getDid());
        }
        return null;
    }

    public void writeToStream(ByteArrayOutputStream out) {
        for (int index = 0; index < 6; ++index) {
            out.write(this.didAddress[index]);
        }
    }

    public Integer getManufacturedId() {
        if (this.didAddress == null) {
            return null;
        }
        return ByteUtils.getInt(this.didAddress[4], this.didAddress[5]);
    }

    public Long getDid() {
        if (this.didAddress == null) {
            return null;
        }
        return ByteUtils.getDWORD(this.didAddress);
    }
}

