/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class DecoderUniqueIdData {
    public static final int DATA_LEN = 6;
    private final long mun;
    private final int mid;

    public DecoderUniqueIdData(long mun, int mid) {
        this.mun = mun;
        this.mid = mid;
    }

    public long getMun() {
        return this.mun;
    }

    public int getMid() {
        return this.mid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[mun=" + String.format("0x%08X", this.mun) + ", mid=" + this.mid + " (" + String.format("0x%04X", this.mid) + ")]";
    }

    public void writeToStream(ByteArrayOutputStream out) {
        for (int index = 0; index < 4; ++index) {
            byte val = (byte)((int)(this.mun >> index * 8) & 0xFF);
            out.write(val);
        }
        out.write(ByteUtils.getLowByte(this.mid));
        out.write(ByteUtils.getHighByte(this.mid));
    }

    public boolean equals(Object obj) {
        if (obj instanceof DecoderUniqueIdData) {
            DecoderUniqueIdData other = (DecoderUniqueIdData)obj;
            if (this.mun == other.mun && this.mid == other.mid) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + (int)this.mun;
        hc = hc * hashMultiplier + this.mid;
        return hc;
    }

    public static DecoderUniqueIdData fromByteArray(byte[] data, int offset) {
        if (data.length < offset + 6) {
            throw new IllegalArgumentException("The size of the provided data does not meet the expected length (>=5). Provided length: " + data.length);
        }
        long mun = ByteUtils.getDWORD(data, offset);
        int mid = ByteUtils.getInt(data[offset + 4], (byte)(data[offset + 5] & 0xF));
        DecoderUniqueIdData uniqueIdData = new DecoderUniqueIdData(mun, mid);
        return uniqueIdData;
    }

    public static String getFormattedDecoderUniqueId(DecoderUniqueIdData decoderUniqueId) {
        if (decoderUniqueId != null) {
            return String.format("%04X %08X", decoderUniqueId.getMid(), decoderUniqueId.getMun());
        }
        return null;
    }
}

