/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class DriveState {
    public static final int DRIVE_ADDRESS_FORMAT_DCC14 = 0;
    public static final int DRIVE_ADDRESS_FORMAT_DCC_SDF = 1;
    public static final int DRIVE_ADDRESS_FORMAT_DCC28 = 2;
    public static final int DRIVE_ADDRESS_FORMAT_DCC128 = 3;
    public static final int DRIVE_ADDRESS_FORMAT_MM14 = 4;
    public static final int DRIVE_ADDRESS_FORMAT_MM27a = 5;
    public static final int DRIVE_ADDRESS_FORMAT_MM27b = 6;
    public static final int DRIVE_ADDRESS_FORMAT_M4 = 7;
    public static final int FUNCTIONS_INDEX_F0_F4 = 0;
    public static final int FUNCTIONS_INDEX_F5_F12 = 1;
    public static final int FUNCTIONS_INDEX_F13_F20 = 2;
    public static final int FUNCTIONS_INDEX_F21_F28 = 3;
    private int address;
    private int addressFormat;
    private int outputActive;
    private int speed;
    private DirectionEnum direction;
    private int lights;
    private byte[] functions;

    public DriveState(int address, int addressFormat, int outputActive, int speed, int lights) {
        this.address = address;
        this.addressFormat = addressFormat;
        this.outputActive = outputActive;
        this.speed = speed & 0x7F;
        this.direction = DirectionEnum.valueOf(speed & 0x80);
        this.lights = lights;
    }

    public DriveState(int address, int addressFormat, int outputActive, int speed, byte[] functions) {
        this.address = address;
        this.addressFormat = addressFormat;
        this.outputActive = outputActive;
        this.speed = speed & 0x7F;
        this.direction = DirectionEnum.valueOf(speed & 0x80);
        this.lights = ByteUtils.getBit(functions[0], 4);
        this.functions = functions;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getAddressFormat() {
        return this.addressFormat;
    }

    public void setAddressFormat(int addressFormat) {
        this.addressFormat = addressFormat;
    }

    public int getOutputActive() {
        return this.outputActive;
    }

    public void setOutputActive(int outputActive) {
        this.outputActive = outputActive;
    }

    public int getSpeed() {
        return this.speed & 0x7F;
    }

    public void setSpeed(int speed) {
        this.speed = speed & 0x7F;
    }

    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public int getLights() {
        return this.lights;
    }

    public void setLights(int lights) {
        this.lights = lights;
    }

    public byte[] getFunctions() {
        return this.functions;
    }

    public void setFunctions(byte[] functions) {
        this.functions = functions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DriveState[");
        sb.append("address=").append(this.address);
        sb.append(",addressFormat=").append(this.addressFormat);
        sb.append(",outputActive=").append(this.outputActive);
        sb.append(",speed=").append(this.speed);
        sb.append(",direction=").append(this.direction);
        sb.append(",lights=").append(this.lights);
        sb.append(",functions=").append(ByteUtils.bytesToHex(this.functions));
        return sb.toString();
    }
}

