/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.Serializable;
import java.util.Collection;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.collections4.IterableUtils;
import org.bidib.jbidibc.messages.utils.collections4.Predicate;

public class Feature
implements Serializable,
Comparable<Feature> {
    private static final long serialVersionUID = 1L;
    private int type;
    private int value;

    public Feature() {
        this.type = -1;
    }

    public Feature(int type, int value) {
        this.type = type;
        this.value = value;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getFeatureName() {
        try {
            return FeatureEnum.valueOf(ByteUtils.getLowByte(this.type)).name();
        }
        catch (IllegalArgumentException ex) {
            return String.valueOf(this.type);
        }
    }

    public static String getFeatureName(byte type) {
        try {
            return FeatureEnum.valueOf(type).name();
        }
        catch (IllegalArgumentException ex) {
            return String.valueOf(type);
        }
    }

    public FeatureEnum getFeatureEnum() {
        try {
            return FeatureEnum.valueOf(ByteUtils.getLowByte(this.type));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean isRequestedFeature(int requestedFeature) {
        return this.getType() == requestedFeature;
    }

    public boolean isRequestedFeature(FeatureEnum requestedFeature) {
        return ByteUtils.getLowByte(this.getType()) == requestedFeature.getType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Feature) {
            Feature other = (Feature)obj;
            return this.getType() == other.getType() && this.getValue() == other.getValue();
        }
        return false;
    }

    public int hashCode() {
        return this.getType();
    }

    @Override
    public int compareTo(Feature other) {
        return this.getType() > other.getType() ? 1 : (this.getType() < other.getType() ? -1 : 0);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + this.type + ",value=" + this.value + "]";
    }

    public static Feature valueOf(String key, int value) {
        Feature result = null;
        FeatureEnum featureEnum = null;
        for (FeatureEnum e : FeatureEnum.values()) {
            if (!e.name().equals(key)) continue;
            featureEnum = e;
            break;
        }
        result = featureEnum != null ? new Feature(ByteUtils.getInt(featureEnum.getType()), value) : new Feature(Integer.parseInt(key), value);
        return result;
    }

    public static Feature findFeature(Collection<Feature> features, final int requestedFeatureId) {
        Feature feature = IterableUtils.find(features, new Predicate<Feature>(){

            @Override
            public boolean evaluate(Feature feature) {
                return feature.isRequestedFeature(requestedFeatureId);
            }
        });
        return feature;
    }

    public static Boolean getBooleanFeatureValue(Collection<Feature> features, int requestedFeatureId) {
        Boolean result = null;
        Feature feature = Feature.findFeature(features, requestedFeatureId);
        if (feature != null) {
            result = feature.getValue() > 0;
        }
        return result;
    }

    public static Boolean getBitFeatureValue(Collection<Feature> features, int requestedFeatureId, int bit) {
        Boolean result = null;
        Feature feature = Feature.findFeature(features, requestedFeatureId);
        if (feature != null) {
            result = ByteUtils.isBitSetEqual(feature.getValue(), 1, bit);
        }
        return result;
    }

    public static Boolean getBooleanFeatureValue(Feature feature) {
        Boolean result = null;
        if (feature != null) {
            result = feature.getValue() > 0;
        }
        return result;
    }

    public static Integer getIntegerFeatureValue(Collection<Feature> features, FeatureEnum requestedFeature) {
        Integer result = null;
        Feature feature = Feature.findFeature(features, requestedFeature.getNumber());
        if (feature != null) {
            result = feature.getValue();
        }
        return result;
    }

    public static int getIntFeatureValue(Collection<Feature> features, int requestedFeatureId) {
        int result = 0;
        Feature feature = Feature.findFeature(features, requestedFeatureId);
        if (feature != null) {
            result = feature.getValue();
        }
        return result;
    }

    public static Integer getFeatureNumberByName(String name) {
        Integer result = null;
        FeatureEnum featureEnum = null;
        for (FeatureEnum e : FeatureEnum.values()) {
            if (!e.name().equals(name)) continue;
            featureEnum = e;
            break;
        }
        if (featureEnum != null) {
            result = ByteUtils.getInt(featureEnum.getType());
        }
        return result;
    }

    public static Feature clone(Feature feature) {
        return new Feature(feature.type, feature.value);
    }
}

