/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

public class FeedbackDynStateData
implements Comparable<FeedbackDynStateData> {
    private final int decoderAddress;
    private int dynNumber;
    private int dynValue;
    private Integer timestamp;
    private String formattedDynValue;

    public FeedbackDynStateData(int address, int dynNumber, int dynValue, Integer timestamp) {
        this.decoderAddress = address;
        this.dynNumber = dynNumber;
        this.dynValue = dynValue;
        this.timestamp = timestamp;
    }

    public int getDecoderAddress() {
        return this.decoderAddress;
    }

    public int getDynNumber() {
        return this.dynNumber;
    }

    public int getDynValue() {
        return this.dynValue;
    }

    public Integer getTimestamp() {
        return this.timestamp;
    }

    public String getFormattedDynValue() {
        if (this.formattedDynValue == null) {
            switch (this.dynNumber) {
                case 46: {
                    this.formattedDynValue = String.format("%.1f V", Float.valueOf(((float)this.dynValue + 50.0f) / 10.0f));
                    break;
                }
                default: {
                    this.formattedDynValue = String.format("%d", this.dynValue);
                }
            }
        }
        return this.formattedDynValue;
    }

    public void appendDynState(StringBuilder sb) {
        sb.append("[").append(this.dynNumber).append("=").append(this.getFormattedDynValue());
        if (this.timestamp != null) {
            sb.append(", ts=").append(this.timestamp);
        }
        sb.append("]\n");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.decoderAddress);
        result.append(":").append(this.dynNumber).append("=").append(this.dynValue);
        if (this.timestamp != null) {
            result.append(", ts=").append(this.timestamp);
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.decoderAddress;
        result = 31 * result + this.dynNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeedbackDynStateData)) {
            return false;
        }
        FeedbackDynStateData other = (FeedbackDynStateData)obj;
        if (this.decoderAddress != other.decoderAddress) {
            return false;
        }
        return this.dynNumber == other.dynNumber;
    }

    @Override
    public int compareTo(FeedbackDynStateData other) {
        return this.hashCode() == other.hashCode() ? 0 : 1;
    }
}

