/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcConfig {
    private final BidibPort bidibPort;
    private final int value1;
    private final int value2;
    private final int value3;
    private final int value4;

    public LcConfig(BidibPort bidibPort, int value1, int value2, int value3, int value4) {
        this.bidibPort = bidibPort;
        this.value1 = value1;
        this.value2 = value2;
        this.value3 = value3;
        this.value4 = value4;
    }

    public final BidibPort getBidibPort() {
        return this.bidibPort;
    }

    public LcOutputType getOutputType(PortModelEnum portModel) {
        return this.bidibPort.getPortType(portModel);
    }

    public int getOutputNumber(PortModelEnum portModel) {
        return this.bidibPort.getPortNumber(portModel);
    }

    public int getValue1() {
        return this.value1;
    }

    public int getValue2() {
        return this.value2;
    }

    public int getValue3() {
        return this.value3;
    }

    public int getValue4() {
        return this.value4;
    }

    public byte[] getPortConfig() {
        return new byte[]{ByteUtils.getLowByte(this.value1), ByteUtils.getLowByte(this.value2), ByteUtils.getLowByte(this.value3), ByteUtils.getLowByte(this.value4)};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LcConfig[bidibPort=");
        sb.append(this.bidibPort).append(",value1=").append(this.value1).append(",value2=").append(this.value2).append(",value3=").append(this.value3).append(",value4=").append(this.value4).append("]");
        return sb.toString();
    }
}

