/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.exception.ProtocolInvalidContentException;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.Int32PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.port.RgbPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.collections4.MapUtils;

public class LcConfigX {
    private final BidibPort bidibPort;
    private Map<Byte, PortConfigValue<?>> values = new LinkedHashMap();

    public LcConfigX(BidibPort bidibPort, Map<Byte, PortConfigValue<?>> values) {
        this.bidibPort = bidibPort;
        this.values.putAll(values);
    }

    public final BidibPort getBidibPort() {
        return this.bidibPort;
    }

    public LcOutputType getOutputType(PortModelEnum portModel) {
        return this.bidibPort.getPortType(portModel);
    }

    public int getOutputNumber(PortModelEnum portModel) {
        return this.bidibPort.getPortNumber(portModel);
    }

    public Map<Byte, PortConfigValue<?>> getPortConfig() {
        return this.values;
    }

    public <T> T getPortConfigValue(Byte key) {
        return (T)this.values.get(key).getValue();
    }

    public boolean isContinueDetected() {
        return MapUtils.isNotEmpty(this.values) && this.values.containsKey((byte)-1);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LcConfigX) {
            LcConfigX other = (LcConfigX)obj;
            if (!this.bidibPort.equals(other.bidibPort)) {
                return false;
            }
            return this.values.equals(other.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LcConfigX[bidibPort=");
        sb.append(this.bidibPort).append(",values=").append(this.values).append("]");
        return sb.toString();
    }

    public static byte[] getCodedPortConfig(Logger logger, LcConfigX lcConfigX, PortModelEnum portModel) throws ProtocolInvalidContentException {
        LcOutputType outputType = lcConfigX.getOutputType(portModel);
        int outputNumber = lcConfigX.getOutputNumber(portModel);
        LinkedHashMap values = new LinkedHashMap();
        values.putAll(lcConfigX.getPortConfig());
        byte outputTypeValue = outputType.getType();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switch (portModel) {
            case flat_extended: 
            case flat: {
                baos.write(ByteUtils.getLowByte(outputNumber));
                baos.write(ByteUtils.getHighByte(outputNumber));
                break;
            }
            default: {
                baos.write(outputTypeValue);
                baos.write(ByteUtils.getLowByte(outputNumber, 127));
            }
        }
        if (values.containsKey((byte)-127)) {
            ReconfigPortConfigValue reconfigPortConfigValue = (ReconfigPortConfigValue)values.get((byte)-127);
            int n = reconfigPortConfigValue.getValue();
            try {
                baos.write(-127);
                baos.write(ByteUtils.toReconfig(n));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            values.remove((byte)-127);
        }
        if (MapUtils.isNotEmpty(values)) {
            try {
                for (Map.Entry entry : values.entrySet()) {
                    int pIntValue;
                    byte pEnum = (Byte)entry.getKey();
                    if (entry.getValue() == null) continue;
                    baos.write(pEnum);
                    if ((pEnum & 0x80) == 128) {
                        switch (pEnum) {
                            case -1: {
                                break;
                            }
                            case -128: {
                                RgbPortConfigValue rgbPortConfigValue = (RgbPortConfigValue)entry.getValue();
                                pIntValue = rgbPortConfigValue.getValue();
                                baos.write(ByteUtils.toRGB(pIntValue));
                                break;
                            }
                            case -127: {
                                ReconfigPortConfigValue reconfigPortConfigValue = (ReconfigPortConfigValue)entry.getValue();
                                pIntValue = reconfigPortConfigValue.getValue();
                                baos.write(ByteUtils.toReconfig(pIntValue));
                                break;
                            }
                            default: {
                                Int32PortConfigValue int32PortConfigValue = (Int32PortConfigValue)entry.getValue();
                                pIntValue = int32PortConfigValue.getValue().intValue();
                                baos.write(ByteUtils.toDWORD(pIntValue));
                                break;
                            }
                        }
                        continue;
                    }
                    if ((pEnum & 0x40) == 64) {
                        Int16PortConfigValue int16PortConfigValue = (Int16PortConfigValue)entry.getValue();
                        pIntValue = int16PortConfigValue.getValue();
                        baos.write(ByteUtils.toWORD(pIntValue));
                        continue;
                    }
                    BytePortConfigValue bytePortConfigValue = (BytePortConfigValue)entry.getValue();
                    byte pValue = bytePortConfigValue.getValue();
                    baos.write(pValue);
                }
            }
            catch (Exception ex) {
                if (logger != null) {
                    logger.warn("Prepare coded port config failed.", ex);
                }
                throw new ProtocolInvalidContentException("Create message from provided data failed.", ex);
            }
        }
        return baos.toByteArray();
    }

    public static LcConfigX getLcConfigX(Logger logger, byte[] data) {
        LinkedHashMap values = new LinkedHashMap();
        if (data.length > 2) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
                bais.skip(2L);
                while (bais.available() > 0) {
                    Integer integerValue;
                    byte pEnum = ByteUtils.getLowByte(bais.read());
                    int bytesRead = 0;
                    if ((pEnum & 0x80) == 128) {
                        switch (pEnum) {
                            case -1: {
                                values.put(pEnum, null);
                                break;
                            }
                            case -128: {
                                byte[] rgbValue = new byte[3];
                                bytesRead = bais.read(rgbValue);
                                integerValue = ByteUtils.getRGB(rgbValue);
                                values.put(pEnum, new RgbPortConfigValue(integerValue));
                                break;
                            }
                            case -127: {
                                byte[] reconfigValue = new byte[3];
                                bytesRead = bais.read(reconfigValue);
                                integerValue = ByteUtils.getReconfig(reconfigValue);
                                values.put(pEnum, new ReconfigPortConfigValue(integerValue));
                                break;
                            }
                            default: {
                                byte[] intValue = new byte[4];
                                bytesRead = bais.read(intValue);
                                Long longValue = ByteUtils.getDWORD(intValue);
                                values.put(pEnum, new Int32PortConfigValue(longValue));
                                break;
                            }
                        }
                        continue;
                    }
                    if ((pEnum & 0x40) == 64) {
                        byte[] intValue = new byte[2];
                        bytesRead = bais.read(intValue);
                        integerValue = ByteUtils.getWORD(intValue);
                        values.put(pEnum, new Int16PortConfigValue(integerValue));
                        continue;
                    }
                    byte[] byteVal = new byte[1];
                    bytesRead = bais.read(byteVal);
                    Byte byteValue = byteVal[0];
                    values.put(pEnum, new BytePortConfigValue(byteValue));
                }
            }
            catch (Exception ex) {
                logger.warn("Read content of message failed.", ex);
            }
        }
        BidibPort bidibPort = BidibPort.prepareBidibPort(data[0], data[1]);
        return new LcConfigX(bidibPort, values);
    }

    private static String formatPortConfigKey(byte pEnum) {
        try {
            PortConfigKeys pck = PortConfigKeys.valueOf(pEnum);
            return pck.name();
        }
        catch (Exception ex) {
            return ByteUtils.byteToHex(pEnum);
        }
    }
}

