/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.util.Arrays;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.enums.AccessoryOkayEnum;
import org.bidib.jbidibc.messages.enums.AnalogPortEnum;
import org.bidib.jbidibc.messages.enums.BacklightPortEnum;
import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.enums.FeedbackPortEnum;
import org.bidib.jbidibc.messages.enums.FlagEnum;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.enums.MacroEnum;
import org.bidib.jbidibc.messages.enums.MotorPortEnum;
import org.bidib.jbidibc.messages.enums.ServoPortEnum;
import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class LcMacro {
    private final byte[] content;
    private static final byte SYSTEM_FUNCTION = ByteUtils.getLowByte(255);
    public static final byte[] MACRO_START_OFF = new byte[]{63, -65, 127, -1};

    public LcMacro(byte[] content) {
        this.content = content;
    }

    public LcMacro(int macroNumber, int stepNumber, int delay, int outputType, int portNumber, int value) {
        this.content = new byte[]{ByteUtils.getLowByte(macroNumber), ByteUtils.getLowByte(stepNumber), ByteUtils.getLowByte(delay), ByteUtils.getLowByte(outputType), ByteUtils.getLowByte(portNumber), ByteUtils.getLowByte(value)};
    }

    public LcMacro(byte macroNumber, byte stepNumber, byte delay, byte outputType, byte portNumber, byte value) {
        this.content = new byte[]{macroNumber, stepNumber, delay, outputType, portNumber, value};
    }

    public LcMacro(byte macroNumber, byte stepNumber, byte delay, LcOutputType outputType, byte portNumber, BidibEnum status) {
        this.content = new byte[]{macroNumber, stepNumber, delay, outputType.getType(), portNumber, status != null ? status.getType() : (byte)0};
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte getMacroNumber() {
        return this.content[0];
    }

    public byte getStepNumber() {
        return this.content[1];
    }

    public byte getDelay() {
        return this.content[2];
    }

    public BidibPort getBidibPort() {
        return BidibPort.prepareBidibPort(this.content[3], this.content[4]);
    }

    public BidibEnum getStatus(LcOutputType outputType) {
        try {
            return LcMacro.toPortStatus(outputType, this.content[5]);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidConfigurationException("No port status available for output type: " + outputType);
        }
    }

    public byte getPortValue(LcOutputType outputType) {
        return LcMacro.getPortValue(outputType, this.content[5]);
    }

    public boolean isSystemFunction() {
        return this.getDelay() == SYSTEM_FUNCTION;
    }

    public LcOutputType getSystemFunctionType() {
        return LcOutputType.valueOf(this.content[3]);
    }

    public byte getSystemFunctionValue() {
        return this.content[4];
    }

    public byte getSystemFunctionExtValue() {
        return this.content[5];
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LcMacro) {
            LcMacro other = (LcMacro)obj;
            return Arrays.equals(this.content, other.content);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[macroNumber=").append(ByteUtils.getInt(this.getMacroNumber())).append(",stepNumber=").append(ByteUtils.getInt(this.getStepNumber())).append(",delay=").append(ByteUtils.getInt(this.getDelay())).append(",bidibPort=").append(this.getBidibPort()).append(",portstatus=").append(ByteUtils.getInt(this.content[5])).append("]");
        return sb.toString();
    }

    public static BidibEnum toPortStatus(LcOutputType outputType, byte value) {
        Enum result = null;
        switch (outputType) {
            case ANALOGPORT: {
                result = AnalogPortEnum.valueOf(value);
                break;
            }
            case BACKLIGHTPORT: {
                result = BacklightPortEnum.START;
                break;
            }
            case LIGHTPORT: {
                result = LightPortEnum.valueOf(value);
                break;
            }
            case MOTORPORT: {
                result = MotorPortEnum.valueOf(ByteUtils.getLowByte(ByteUtils.getBit(value, 7)));
                break;
            }
            case SERVOPORT: {
                result = ServoPortEnum.START;
                break;
            }
            case SOUNDPORT: {
                result = SoundPortEnum.valueOf(value);
                break;
            }
            case SWITCHPORT: {
                result = SwitchPortEnum.valueOf(value);
                break;
            }
            case SWITCHPAIRPORT: {
                result = SwitchPortEnum.valueOf(value);
                break;
            }
            case INPUTPORT: {
                result = InputPortEnum.valueOf(value);
                break;
            }
            case FEEDBACKPORT: {
                result = FeedbackPortEnum.valueOf(value);
                break;
            }
            case END_OF_MACRO: 
            case ACCESSORY_OKAY_INPUTQUERY0: 
            case ACCESSORY_OKAY_INPUTQUERY1: 
            case ACCESSORY_OKAY_NF: 
            case BEGIN_CRITICAL: 
            case END_CRITICAL: 
            case FLAG_CLEAR: 
            case FLAG_QUERY: 
            case FLAG_QUERY0: 
            case FLAG_QUERY1: 
            case FLAG_SET: 
            case INPUT_QUERY0: 
            case INPUT_QUERY1: 
            case DELAY_FIXED: 
            case RANDOM_DELAY: 
            case SERVOMOVE_QUERY: 
            case START_MACRO: 
            case STOP_MACRO: 
            case WAIT_FOR_END_OF_MACRO: {
                break;
            }
            default: {
                throw new InvalidConfigurationException("No port status available for output type: " + outputType);
            }
        }
        return result;
    }

    public static byte getPortStatus(LcMacro macro, LcOutputType outputType) {
        byte result = 0;
        BidibEnum status = macro.getStatus(outputType);
        if (status != null) {
            if (status instanceof AnalogPortEnum) {
                result = ((AnalogPortEnum)status).getType();
            } else if (status instanceof BacklightPortEnum) {
                result = macro.getPortValue(outputType);
            } else if (status instanceof FlagEnum) {
                result = ((FlagEnum)status).getType();
            } else if (status instanceof LightPortEnum) {
                result = ((LightPortEnum)status).getType();
            } else if (status instanceof MotorPortEnum) {
                result = ((MotorPortEnum)status).getType();
            } else if (status instanceof ServoPortEnum) {
                result = macro.getPortValue(outputType);
            } else if (status instanceof SoundPortEnum) {
                result = ((SoundPortEnum)status).getType();
            } else if (status instanceof SwitchPortEnum) {
                result = ((SwitchPortEnum)status).getType();
            } else if (status instanceof AccessoryOkayEnum) {
                result = ((AccessoryOkayEnum)status).getType();
            } else if (status instanceof MacroEnum) {
                result = ((MacroEnum)status).getType();
            } else {
                throw new RuntimeException("Unsupported macro status detected: " + status);
            }
        }
        return result;
    }

    public static byte getPortValue(LcOutputType outputType, byte value) {
        byte result = 0;
        switch (outputType) {
            case BACKLIGHTPORT: 
            case SERVOPORT: {
                result = value;
                break;
            }
            case MOTORPORT: {
                result = ByteUtils.getLowByte(value & 0x7F);
                break;
            }
        }
        return result;
    }
}

