/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.StringUtils;

public class Node {
    public static final byte[] ROOTNODE_ADDR = new byte[]{0};
    public static final String PROPERTY_MAGIC = "magic";
    public static final String PROPERTY_USERNAME = "userName";
    public static final String PROPERTY_PRODUCTNAME = "productName";
    public static final String PROPERTY_FEATURES = "features";
    public static final String PROPERTY_REGISTERED = "registered";
    public static final String PROPERTY_DETACHED = "detached";
    public static final String PROPERTY_STALL = "stall";
    public static final String PROPERTY_SOFTWARE_VERSION = "softwareVersion";
    public static final String PROPERTY_PROTOCOL_VERSION = "protocolVersion";
    public static final String PROPERTY_PORT_FLAT_MODEL = "portFlatModel";
    private final Object accessLock = new Object();
    private final byte[] addr;
    protected long uniqueId;
    protected int version;
    private int relevantPidBits = 16;
    private String[] storedStrings;
    private Integer magic;
    private SoftwareVersion softwareVersion;
    private ProtocolVersion protocolVersion;
    private CommandStationState requestedCommandStationState;
    private List<Feature> features = new LinkedList<Feature>();
    private Integer packetCapacity;
    private AtomicBoolean registered = new AtomicBoolean();
    private AtomicBoolean detached = new AtomicBoolean();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AtomicBoolean stall = new AtomicBoolean();
    private final Object stallTsLock = new Object();
    private final AtomicLong stallTs = new AtomicLong();
    private Logger logger;
    private int stringSize;
    private Integer portFlatModel;

    protected Node(byte[] addr) {
        this(0, addr, 0L);
    }

    private Node(int version, byte[] addr, long uniqueId) {
        this.addr = addr != null ? (byte[])addr.clone() : null;
        this.uniqueId = uniqueId;
        this.version = version;
        this.storedStrings = new String[2];
    }

    public static Node createNode(int version, byte[] addr, long uniqueId) {
        return new Node(version, addr, uniqueId);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public byte[] getAddr() {
        return this.addr;
    }

    public int getVersion() {
        return this.version;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public int getRelevantPidBits() {
        return this.relevantPidBits;
    }

    public void setRelevantPidBits(int relevantPidBits) {
        this.relevantPidBits = relevantPidBits;
    }

    public int getStringSize() {
        return this.stringSize;
    }

    public void setStringSize(int stringSize) {
        this.stringSize = stringSize;
    }

    public void setProductName(String productName) {
        this.setStoredString(0, productName);
    }

    public void setUserName(String userName) {
        this.setStoredString(1, userName);
    }

    public void setStoredString(int index, String value) {
        if (index < 0 || index > 1) {
            throw new IllegalArgumentException("Index not allowed: " + index);
        }
        String oldValue = this.storedStrings[index];
        this.storedStrings[index] = value;
        this.pcs.firePropertyChange(index == 0 ? PROPERTY_PRODUCTNAME : PROPERTY_USERNAME, oldValue, value);
    }

    public String getStoredString(int index) {
        if (index < 0 || index > 1) {
            throw new IllegalArgumentException("Index not allowed: " + index);
        }
        return this.storedStrings[index];
    }

    public boolean hasStoredStrings() {
        return StringUtils.isNotBlank(this.storedStrings[0]) || StringUtils.isNotBlank(this.storedStrings[1]);
    }

    public void setMagic(Integer magic) {
        Integer oldValue = this.magic;
        this.magic = magic;
        this.pcs.firePropertyChange(PROPERTY_MAGIC, oldValue, magic);
    }

    public Integer getMagic() {
        return this.magic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoftwareVersion getSoftwareVersion() {
        Object object = this.accessLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.debug("Get the softwareVersion: {}, uniqueId: {}, node identity: {}", this.softwareVersion, ByteUtils.formatHexUniqueId(this.uniqueId), super.hashCode());
            }
            return this.softwareVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftwareVersion(String softwareVersion) {
        SoftwareVersion oldValue = null;
        Object object = this.accessLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.info("Set the softwareVersion: {}, uniqueId: {}, node identity: {}", softwareVersion, ByteUtils.formatHexUniqueId(this.uniqueId), super.hashCode());
            }
            oldValue = this.softwareVersion;
            this.softwareVersion = SoftwareVersion.parse(softwareVersion);
        }
        this.pcs.firePropertyChange(PROPERTY_SOFTWARE_VERSION, oldValue, softwareVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        SoftwareVersion oldValue = null;
        Object object = this.accessLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.info("Set the softwareVersion: {}, uniqueId: {}, node identity: {}", softwareVersion, ByteUtils.formatHexUniqueId(this.uniqueId), super.hashCode());
            }
            oldValue = this.softwareVersion;
            this.softwareVersion = softwareVersion;
        }
        this.pcs.firePropertyChange(PROPERTY_SOFTWARE_VERSION, oldValue, softwareVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolVersion getProtocolVersion() {
        Object object = this.accessLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.debug("Get the protocolVersion: {}, uniqueId: {}, node identity: {}", this.protocolVersion, ByteUtils.formatHexUniqueId(this.uniqueId), super.hashCode());
            }
            return this.protocolVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        ProtocolVersion oldValue = null;
        Object object = this.accessLock;
        synchronized (object) {
            if (this.logger != null) {
                this.logger.info("Set the protocolVersion: {}, uniqueId: {}, node identity: {}", protocolVersion, ByteUtils.formatHexUniqueId(this.uniqueId), super.hashCode());
            }
            oldValue = this.protocolVersion;
            this.protocolVersion = protocolVersion;
        }
        this.pcs.firePropertyChange(PROPERTY_PROTOCOL_VERSION, oldValue, protocolVersion);
    }

    public int getIdentity() {
        return super.hashCode();
    }

    public Integer getPortFlatModel() {
        return this.portFlatModel;
    }

    public boolean isPortFlatModelAvailable() {
        return this.portFlatModel != null && this.portFlatModel > 0;
    }

    public void setPortFlatModel(Integer portFlatModel) {
        Integer oldValue = this.portFlatModel;
        this.portFlatModel = portFlatModel;
        this.pcs.firePropertyChange(PROPERTY_PORT_FLAT_MODEL, oldValue, portFlatModel);
    }

    public CommandStationState getRequestedCommandStationState() {
        return this.requestedCommandStationState;
    }

    public void setRequestedCommandStationState(CommandStationState requestedCommandStationState) {
        this.requestedCommandStationState = requestedCommandStationState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Feature> getFeatures() {
        Object object = this.accessLock;
        synchronized (object) {
            return this.features;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeature(Feature feature) {
        Feature existing = null;
        Object object = this.accessLock;
        synchronized (object) {
            existing = Feature.findFeature(this.features, feature.getType());
            if (existing != null) {
                this.features.remove(existing);
            }
            this.features.add(feature);
        }
        this.pcs.fireIndexedPropertyChange(PROPERTY_FEATURES, feature.getType(), existing, feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFeatures(List<Feature> features) {
        LinkedList<Feature> oldValue = new LinkedList<Feature>();
        Object object = this.accessLock;
        synchronized (object) {
            oldValue.addAll(this.features);
            this.features.clear();
            if (features != null) {
                this.features.addAll(features);
            }
        }
        this.pcs.firePropertyChange(PROPERTY_FEATURES, oldValue, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(List<Feature> features) {
        LinkedList<Feature> oldValue = new LinkedList<Feature>();
        Object object = this.accessLock;
        synchronized (object) {
            oldValue.addAll(this.features);
            if (features != null) {
                this.features.removeAll(features);
                this.features.addAll(features);
            }
        }
        this.pcs.firePropertyChange(PROPERTY_FEATURES, oldValue, this.features);
    }

    public void setPacketCapacity(int packetCapacity) {
        this.packetCapacity = packetCapacity;
    }

    public int getPacketCapacity() {
        return this.packetCapacity != null ? this.packetCapacity : 64;
    }

    public boolean isRegistered() {
        boolean isRegistered = this.registered.get();
        return isRegistered;
    }

    public void setRegistered(boolean registered) {
        boolean oldValue = this.registered.get();
        if (this.logger != null) {
            this.logger.info("Set the registered flag: {}, oldValue: {}, uniqueId: {}", registered, oldValue, ByteUtils.formatHexUniqueId(this.uniqueId));
        }
        this.registered.set(registered);
        this.pcs.firePropertyChange(PROPERTY_REGISTERED, oldValue, registered);
    }

    public boolean isDetached() {
        boolean isDetached = this.detached.get();
        if (this.logger != null) {
            this.logger.info("The node is detached: {}, uniqueId: {}", isDetached, ByteUtils.formatHexUniqueId(this.uniqueId));
        }
        return isDetached;
    }

    public void setDetached(boolean detached) {
        boolean oldValue = this.detached.get();
        if (this.logger != null) {
            this.logger.info("Set the detached flag: {}, oldValue: {}, uniqueId: {}", detached, oldValue, ByteUtils.formatHexUniqueId(this.uniqueId));
        }
        this.detached.set(detached);
        this.pcs.firePropertyChange(PROPERTY_DETACHED, oldValue, detached);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStall(boolean stall) {
        boolean oldValue;
        block8: {
            oldValue = this.stall.getAndSet(stall);
            if (this.logger != null) {
                this.logger.info("setStall, stall: {}, oldValue: {}", stall, oldValue);
            }
            try {
                if (stall) {
                    this.stallTs.set(System.currentTimeMillis() + 200L);
                } else {
                    this.stallTs.set(0L);
                }
                Object object = this.stallTsLock;
                synchronized (object) {
                    this.stallTsLock.notifyAll();
                }
            }
            catch (Exception ex) {
                if (this.logger == null) break block8;
                this.logger.warn("Lock or unlock the stallLock failed. Current stall: {}, node: {}", stall, this);
            }
        }
        this.pcs.firePropertyChange(PROPERTY_STALL, oldValue, stall);
    }

    public boolean isStall() {
        return this.stall.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockIfStall(long timeout) {
        block9: {
            if (this.logger != null) {
                this.logger.debug("blockIfStall, timeout: {}", timeout);
            }
            try {
                long remainingWait;
                long lockTs;
                if (this.stall.get() && (lockTs = this.stallTs.get()) > 0L && (remainingWait = System.currentTimeMillis() - lockTs) > 0L) {
                    Object object = this.stallTsLock;
                    synchronized (object) {
                        this.stallTsLock.wait(remainingWait);
                        if (this.logger != null) {
                            this.logger.info("blockIfStall, stall: {}, stallTS: {}", this.stall, this.stallTs);
                        }
                    }
                }
                if (this.logger != null) {
                    this.logger.debug("blockIfStall finished.", new Object[0]);
                }
            }
            catch (InterruptedException e) {
                if (this.logger == null) break block9;
                this.logger.warn("Wait for stallLock was interrupted.", new Object[0]);
            }
        }
    }

    public boolean equals(Object other) {
        Node node;
        return other instanceof Node && Arrays.equals((node = (Node)other).getAddr(), this.getAddr()) && node.getUniqueId() == this.uniqueId;
    }

    public int hashCode() {
        return (int)((long)NodeUtils.convertAddress(this.addr) + this.getUniqueId() + (long)this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[version=").append(this.version).append(",addr=").append(Arrays.toString(this.addr)).append(",uniqueId=").append(String.format("0x%014x", this.uniqueId & 0xFFFFFFFFFFFFFFL));
        if (this.softwareVersion != null) {
            sb.append(",sw-version=").append(this.softwareVersion);
        }
        if (this.protocolVersion != null) {
            sb.append(",protocol-version=").append(this.protocolVersion);
        }
        sb.append("]");
        return sb.toString();
    }
}

