/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class PomAddressData {
    private final int address;
    private final PomAddressTypeEnum type;

    public PomAddressData(int address, PomAddressTypeEnum type) {
        this.address = address;
        this.type = type;
    }

    public int getAddress() {
        return this.address;
    }

    public PomAddressTypeEnum getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[address=").append(this.address).append(",type=").append(this.type).append("]");
        return sb.toString();
    }

    public void writeToStream(ByteArrayOutputStream out) {
        if (this.address > 0) {
            out.write(ByteUtils.getLowByte(this.address));
            byte highAddr = ByteUtils.getHighByte(this.address);
            switch (this.getType()) {
                case ACCESSORY: {
                    highAddr = (byte)(highAddr & 0x3F);
                    highAddr = (byte)(highAddr | 0x40);
                    break;
                }
                case EXTENDED_ACCESSORY: {
                    highAddr = (byte)(highAddr | 0x40);
                    highAddr = (byte)(highAddr | 0x80);
                    break;
                }
                default: {
                    highAddr = (byte)(highAddr & 0x3F);
                }
            }
            out.write(highAddr);
        } else {
            out.write(0);
            out.write(0);
        }
    }

    public static PomAddressData fromByteArray(byte[] data, int offset) {
        int index = offset;
        byte lowByte = data[index++];
        byte highByte = data[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        PomAddressData addressData = new PomAddressData(address, PomAddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
        return addressData;
    }

    public static void toByteArray(PomAddressData addressData, byte[] data, int offset) {
        byte highByte;
        byte lowByte;
        data[offset] = lowByte = ByteUtils.getLowByte(addressData.getAddress());
        data[offset + 1] = highByte = ByteUtils.getLowByte(ByteUtils.getHighByte(addressData.getAddress()) | addressData.getType().getType() << 6);
    }

    public static byte[] toByteArray(PomAddressData addressData) {
        byte highByte;
        byte lowByte = ByteUtils.getLowByte(addressData.getAddress());
        byte[] data = new byte[]{lowByte, highByte = ByteUtils.getLowByte(ByteUtils.getHighByte(addressData.getAddress()) | addressData.getType().getType() << 6)};
        return data;
    }

    public boolean equals(Object obj) {
        PomAddressData other;
        return obj instanceof PomAddressData && this.address == (other = (PomAddressData)obj).getAddress() && this.type.equals(other.getType());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

