/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import org.bidib.jbidibc.messages.utils.ByteUtils;

public class ProtocolVersion
implements Comparable<ProtocolVersion> {
    private final int majorVersion;
    private final int minorVersion;
    public static final ProtocolVersion VERSION_0_5 = new ProtocolVersion(0, 5);
    public static final ProtocolVersion VERSION_0_6 = new ProtocolVersion(0, 6);
    public static final ProtocolVersion VERSION_0_7 = new ProtocolVersion(0, 7);
    public static final ProtocolVersion VERSION_0_8 = new ProtocolVersion(0, 8);
    public static final ProtocolVersion VERSION_0_9 = new ProtocolVersion(0, 9);

    public static boolean isUnsupportedProtocolVersion(ProtocolVersion version) {
        return version != null && version.isHigherThan(VERSION_0_9);
    }

    public ProtocolVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    private Integer toInt() {
        return (this.majorVersion << 8) + this.minorVersion;
    }

    public byte[] toByteArray() {
        return new byte[]{ByteUtils.getLowByte(this.minorVersion), ByteUtils.getLowByte(this.majorVersion)};
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public static ProtocolVersion parse(String protocolVersionString) {
        ProtocolVersion protocolVersion = null;
        try {
            String[] splited = protocolVersionString.split("\\.");
            protocolVersion = new ProtocolVersion(Integer.parseInt(splited[0]), Integer.parseInt(splited[1]));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Parse ProtocolVersion from provided string failed: " + protocolVersionString);
        }
        return protocolVersion;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion;
    }

    @Override
    public int compareTo(ProtocolVersion version) {
        return this.toInt().compareTo(version.toInt());
    }

    public boolean isLowerThan(ProtocolVersion versionToCompare) {
        return this.toInt() < versionToCompare.toInt();
    }

    public boolean isLowerOrEqualThan(ProtocolVersion versionToCompare) {
        return this.toInt() <= versionToCompare.toInt();
    }

    public boolean isHigherThan(ProtocolVersion versionToCompare) {
        return this.toInt() > versionToCompare.toInt();
    }

    public boolean isHigherOrEqualThan(ProtocolVersion versionToCompare) {
        return this.toInt() >= versionToCompare.toInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProtocolVersion) {
            return this.toInt().equals(((ProtocolVersion)obj).toInt());
        }
        return false;
    }

    public int hashCode() {
        return this.toInt();
    }
}

