/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.RcPlusDecoderAnswerData;
import org.bidib.jbidibc.messages.enums.RcPlusAcknowledge;

public class RcPlusBindAcceptedData
extends RcPlusDecoderAnswerData {
    private final AddressData address;

    public RcPlusBindAcceptedData(RcPlusAcknowledge acknState, DecoderUniqueIdData uniqueIdData, AddressData address) {
        super(acknState, uniqueIdData);
        this.address = address;
    }

    public AddressData getAddress() {
        return this.address;
    }

    public static RcPlusBindAcceptedData fromByteArray(byte[] data, int offset) {
        if (data.length < offset + 6 + 2) {
            throw new IllegalArgumentException("The size of the provided data does not meet the expected length (=7). Provided length: " + data.length);
        }
        RcPlusAcknowledge acknState = RcPlusAcknowledge.valueOf(data[offset]);
        DecoderUniqueIdData uniqueIdData = DecoderUniqueIdData.fromByteArray(data, offset + 1);
        AddressData address = AddressData.fromByteArray(data, offset + 1 + 6);
        RcPlusBindAcceptedData answerData = new RcPlusBindAcceptedData(acknState, uniqueIdData, address);
        return answerData;
    }

    public void writeToStream(ByteArrayOutputStream out) {
        this.getUniqueId().writeToStream(out);
        this.getAddress().writeToStream(out);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RcPlusBindAcceptedData,address=");
        sb.append(this.address);
        return sb.toString();
    }
}

