/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;

public class RcPlusBindData {
    private final DecoderUniqueIdData uniqueIdData;
    private final AddressData address;

    public RcPlusBindData(DecoderUniqueIdData uniqueIdData, AddressData address) {
        this.uniqueIdData = uniqueIdData;
        this.address = address;
    }

    public DecoderUniqueIdData getUniqueId() {
        return this.uniqueIdData;
    }

    public AddressData getAddress() {
        return this.address;
    }

    public static RcPlusBindData fromByteArray(byte[] data, int offset) {
        if (data.length < offset + 7) {
            throw new IllegalArgumentException("The size of the provided data does not meet the expected length (=7). Provided length: " + data.length);
        }
        DecoderUniqueIdData uniqueIdData = DecoderUniqueIdData.fromByteArray(data, offset);
        AddressData address = null;
        if (data.length > offset + 6) {
            address = AddressData.fromByteArray(data, offset + 6);
        }
        RcPlusBindData answerData = new RcPlusBindData(uniqueIdData, address);
        return answerData;
    }

    public void writeToStream(ByteArrayOutputStream out) {
        this.getUniqueId().writeToStream(out);
        this.getAddress().writeToStream(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RcPlusBindData,address=");
        sb.append(this.address).append(",uniqueIdData=").append(this.uniqueIdData);
        return sb.toString();
    }
}

