/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.util.ArrayList;
import java.util.List;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class SoftwareVersion
implements Comparable<SoftwareVersion> {
    protected final int firstVersion;
    protected final int secondVersion;
    protected final int thirdVersion;
    private List<SoftwareVersion> childrenVersions;

    public SoftwareVersion(int firstVersion, int secondVersion, int thirdVersion) {
        this.firstVersion = firstVersion;
        this.secondVersion = secondVersion;
        this.thirdVersion = thirdVersion;
    }

    public int getMajorVersion() {
        return this.firstVersion;
    }

    public int getMinorVersion() {
        return this.secondVersion;
    }

    public int getMicroVersion() {
        return this.thirdVersion;
    }

    public List<SoftwareVersion> getChildrenVersions() {
        return this.childrenVersions;
    }

    public void setChildrenVersions(List<SoftwareVersion> childrenVersions) {
        this.childrenVersions = childrenVersions;
    }

    public void addChildVersion(SoftwareVersion childVersion) {
        if (this.childrenVersions == null) {
            this.childrenVersions = new ArrayList<SoftwareVersion>();
        }
        this.childrenVersions.add(childVersion);
    }

    public Integer toInt() {
        return this.firstVersion << 16 | this.secondVersion << 8 | this.thirdVersion;
    }

    public byte[] asByteArray() {
        return new byte[]{ByteUtils.getLowByte(this.thirdVersion), ByteUtils.getLowByte(this.secondVersion), ByteUtils.getLowByte(this.firstVersion)};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("%d.%02d.%02d", this.firstVersion, this.secondVersion, this.thirdVersion));
        if (this.childrenVersions != null) {
            for (SoftwareVersion child : this.childrenVersions) {
                sb.append(", ").append(child);
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(SoftwareVersion version) {
        return this.toInt().compareTo(version.toInt());
    }

    public int compareToMinorVersion(SoftwareVersion versionToCompare) {
        SoftwareVersion versionMinor = SoftwareVersion.build(versionToCompare.firstVersion, versionToCompare.secondVersion, 0);
        SoftwareVersion ownVersionMinor = SoftwareVersion.build(this.firstVersion, this.secondVersion, 0);
        return ownVersionMinor.toInt().compareTo(versionMinor.toInt());
    }

    public int compareToMajorVersion(SoftwareVersion versionToCompare) {
        SoftwareVersion versionMajor = SoftwareVersion.build(versionToCompare.firstVersion, 0, 0);
        SoftwareVersion ownVersionMajor = SoftwareVersion.build(this.firstVersion, 0, 0);
        return ownVersionMajor.toInt().compareTo(versionMajor.toInt());
    }

    public boolean isLowerThan(SoftwareVersion versionToCompare) {
        if (versionToCompare == null) {
            return false;
        }
        return this.toInt() < versionToCompare.toInt();
    }

    public boolean isLowerOrEqualThan(SoftwareVersion versionToCompare) {
        return this.toInt() <= versionToCompare.toInt();
    }

    public boolean isHigherThan(SoftwareVersion versionToCompare) {
        if (versionToCompare == null) {
            return true;
        }
        return this.toInt() > versionToCompare.toInt();
    }

    public boolean isHigherOrEqualThan(SoftwareVersion versionToCompare) {
        return this.toInt() >= versionToCompare.toInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SoftwareVersion) {
            return this.toInt().equals(((SoftwareVersion)obj).toInt());
        }
        return false;
    }

    public int hashCode() {
        return this.toInt();
    }

    public static SoftwareVersion build(int firstVersion, int secondVersion, int thirdVersion) {
        return new SoftwareVersion(firstVersion, secondVersion, thirdVersion);
    }

    public static SoftwareVersion parse(String version) {
        try {
            String[] splited = version.split("\\.");
            return new SoftwareVersion(Integer.parseInt(splited[0]), Integer.parseInt(splited[1]), Integer.parseInt(splited[2]));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("The provided version string is not a valid SoftwareVersion: " + version, ex);
        }
    }
}

