/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class TidData {
    private final DecoderUniqueIdData uniqueIdData;
    private final int sid;

    public TidData(DecoderUniqueIdData uniqueIdData, int sid) {
        this.uniqueIdData = uniqueIdData;
        this.sid = sid;
    }

    public DecoderUniqueIdData getUniqueId() {
        return this.uniqueIdData;
    }

    public int getSid() {
        return this.sid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[sid=" + this.sid + ", uniqueId=" + this.uniqueIdData + "]";
    }

    public void writeToStream(ByteArrayOutputStream out) {
        this.uniqueIdData.writeToStream(out);
        out.write((byte)this.sid & 0xFF);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TidData) {
            TidData other = (TidData)obj;
            if (this.sid == other.sid && this.uniqueIdData.equals(other.uniqueIdData)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.uniqueIdData.hashCode();
        hc = hc * hashMultiplier + this.sid;
        return hc;
    }

    public static TidData fromByteArray(byte[] data, int offset) {
        if (data.length < offset + 6) {
            throw new IllegalArgumentException("The size of the provided data does not meet the expected length (>=5). Provided length: " + data.length);
        }
        DecoderUniqueIdData uniqueIdData = DecoderUniqueIdData.fromByteArray(data, offset);
        int sid = ByteUtils.getInt(data[offset + 6]);
        TidData tidData = new TidData(uniqueIdData, sid);
        return tidData;
    }
}

