/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.base;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageReceiver;
import org.bidib.jbidibc.messages.base.BaseBidib;
import org.bidib.jbidibc.messages.base.ConnectionStatusListener;
import org.bidib.jbidibc.messages.base.DataTransferStatusListener;
import org.bidib.jbidibc.messages.base.RawMessageListener;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.exception.PortNotReadyForSendException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.logger.EmptyLogger;
import org.bidib.jbidibc.messages.logger.Logger;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;

public abstract class AbstractBaseBidib<MR extends MessageReceiver>
implements BaseBidib<MR> {
    private static final int FREE_BUFFER_QUEUE_SIZE = 2048;
    private Logger logger = new EmptyLogger();
    private Logger loggerRAW = new EmptyLogger();
    private final BlockingQueue<ByteArrayOutputStream> sendQueue = new LinkedBlockingQueue<ByteArrayOutputStream>();
    private Thread sendQueueWorker;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicLong sendQueueWorkerThreadId = new AtomicLong();
    private final BlockingQueue<ByteArrayOutputStream> receiveQueue = new LinkedBlockingQueue<ByteArrayOutputStream>();
    private final ConcurrentLinkedQueue<ByteArrayOutputStream> freeBufferQueue = new ConcurrentLinkedQueue();
    private Thread receiveQueueWorker;
    private final AtomicBoolean receiverRunning = new AtomicBoolean();
    private final AtomicLong receiveQueueWorkerThreadId = new AtomicLong();
    private MR messageReceiver;
    private final AtomicBoolean isConnected = new AtomicBoolean();
    protected boolean firstPacketSent = false;
    private DataTransferStatusListener dataTransferStatusListener;
    private ConnectionStatusListener connectionStatusListener;
    private RawMessageListener rawMessageListener;
    private String connectedPortName;
    private volatile long delayAfterSend;
    private final Object sendQueueTerminateLock = new Object();
    private final ScheduledExecutorService terminateQueueWorkers = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("terminateQueueWorkers-thread-%d").build());
    private final Object receiveQueueTerminateLock = new Object();

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerRAW(Logger loggerRAW) {
        this.loggerRAW = loggerRAW;
    }

    protected boolean isConnected() {
        return this.isConnected.get();
    }

    protected void setConnected(boolean connected) {
        this.logger.info("Set the connected flag: {}", connected);
        this.isConnected.set(connected);
        if (connected) {
            this.fireConnectionOpened();
        } else {
            this.fireConnectionClosed();
        }
    }

    public void initialize() {
        this.logger.info("Initialize the free buffer queue.", new Object[0]);
        try {
            for (int i = 0; i < 2048; ++i) {
                ByteArrayOutputStream item = new ByteArrayOutputStream(256);
                this.freeBufferQueue.add(item);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Put the buffers into queue failed.", ex);
        }
    }

    @Override
    public void setMessageReceiver(MR messageReceiver) {
        this.logger.info("Set the messageReceiver: {}", messageReceiver);
        this.messageReceiver = messageReceiver;
    }

    @Override
    public MR getMessageReceiver() {
        return this.messageReceiver;
    }

    @Override
    public void setDelayAfterSend(long delay) {
        this.logger.info("Set the delay after send: {}", delay);
        this.delayAfterSend = delay;
    }

    public DataTransferStatusListener getDataTransferStatusListener() {
        return this.dataTransferStatusListener;
    }

    public void setDataTransferStatusListener(DataTransferStatusListener dataTransferStatusListener) {
        this.dataTransferStatusListener = dataTransferStatusListener;
    }

    public ConnectionStatusListener getConnectionStatusListener() {
        return this.connectionStatusListener;
    }

    public void setConnectionStatusListener(ConnectionStatusListener connectionStatusListener) {
        this.connectionStatusListener = connectionStatusListener;
    }

    public RawMessageListener getRawMessageListener() {
        return this.rawMessageListener;
    }

    public void setRawMessageListener(RawMessageListener rawMessageListener) {
        this.rawMessageListener = rawMessageListener;
    }

    protected void internalOpen(String portName, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.firstPacketSent = false;
        this.connectedPortName = portName;
    }

    public Optional<String> getConnectedPortName() {
        return Optional.ofNullable(this.connectedPortName);
    }

    @Override
    public void send(byte[] data) {
        try {
            ByteArrayOutputStream buffer = this.freeBufferQueue.poll();
            buffer.write(data, 0, data.length);
            boolean added = this.sendQueue.offer(buffer);
            if (!added) {
                this.logger.error("The message was not added to the send queue: {}", ByteUtils.bytesToHex(data));
            }
        }
        catch (Exception ex) {
            this.logger.warn("Put message to sendQueue failed.", ex);
            this.logger.error("The message was not added to the send queue: {}", ByteUtils.bytesToHex(data));
        }
    }

    public void startReceiverAndQueues(MR messageProcessor, Context context) {
        this.logger.info("Start the receiver and queues.", new Object[0]);
        this.startSendQueueWorker();
        this.startReceiveQueueWorker();
    }

    public void stopReceiverAndQueues(MR messageReceiver) {
        this.logger.info("Stop the receiver and queues.", new Object[0]);
        this.stopSendQueueWorker();
        this.stopReceiveQueueWorker();
    }

    private void startSendQueueWorker() {
        this.running.set(true);
        this.logger.info("Start the sendQueueWorker. Current sendQueueWorker: {}", this.sendQueueWorker);
        if (this.sendQueueWorker != null) {
            throw new InvalidConfigurationException("The sendQueueWorker is running already. Check your configuration!");
        }
        this.sendQueueWorker = new Thread(() -> {
            try {
                this.processSendQueue();
            }
            catch (Exception ex) {
                this.logger.warn("The processing of the send queue was terminated with an exception!", ex);
                this.running.set(false);
            }
            this.logger.info("Process send queue has finished.", new Object[0]);
        }, "sendQueueWorker");
        try {
            this.sendQueueWorkerThreadId.set(this.sendQueueWorker.getId());
            this.sendQueueWorker.setPriority(8);
            this.sendQueueWorker.start();
        }
        catch (Exception ex) {
            this.logger.error("Start the sendQueueWorker failed.", ex);
        }
    }

    public boolean isSendQueueEmpty() {
        return this.sendQueue.isEmpty();
    }

    private void stopSendQueueWorker() {
        this.logger.info("Stop the send queue worker.", new Object[0]);
        this.running.set(false);
        if (this.sendQueueWorker != null) {
            if (Thread.currentThread().equals(this.sendQueueWorker)) {
                this.terminateQueueWorkers.schedule(() -> this.doTerminateSendQueue(), 10L, TimeUnit.MILLISECONDS);
            } else {
                this.doTerminateSendQueue();
            }
        } else {
            this.logger.info("No sendQueueWorker to stop assigned.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTerminateSendQueue() {
        try {
            this.sendQueueWorker.interrupt();
            this.logger.info("Wait for termination of sendQueue worker.", new Object[0]);
            Object object = this.sendQueueTerminateLock;
            synchronized (object) {
                this.sendQueueTerminateLock.wait(1000L);
            }
            this.sendQueueWorker.join(1000L);
            this.logger.info("sendQueueWorker has finished.", new Object[0]);
        }
        catch (Exception ex) {
            this.logger.warn("Interrupt sendQueueWorker failed.", ex);
        }
        this.sendQueueWorker = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSendQueue() {
        ByteArrayOutputStream data = null;
        this.logger.info("The sendQueueWorker is ready for processing.", new Object[0]);
        while (this.running.get()) {
            try {
                data = this.sendQueue.take();
                this.fireSendStarted();
                this.sendData(data, this.rawMessageListener);
                if (this.delayAfterSend > 0L) {
                    Thread.sleep(this.delayAfterSend);
                }
            }
            catch (InterruptedException ex) {
                this.logger.info("Get message from sendQueue failed because thread was interrupted.", new Object[0]);
                Thread.interrupted();
            }
            catch (PortNotReadyForSendException ex) {
                this.logger.warn("The message was not send because the port is not ready for sending, e.g. CTS low.", ex);
            }
            catch (Exception ex) {
                this.logger.warn("Get message from sendQueue or send data failed.", ex);
            }
            finally {
                this.fireSendStopped();
                if (data != null) {
                    data.reset();
                    this.freeBufferQueue.add(data);
                }
            }
            data = null;
        }
        this.logger.info("The sendQueueWorker has finished processing.", new Object[0]);
        this.sendQueueWorkerThreadId.set(0L);
        Object object = this.sendQueueTerminateLock;
        synchronized (object) {
            this.sendQueueTerminateLock.notifyAll();
        }
    }

    protected abstract void sendData(ByteArrayOutputStream var1, RawMessageListener var2);

    public void receive(byte[] data, int len) {
        this.loggerRAW.info("<< Receive, len: {}", len);
        try {
            ByteArrayOutputStream buffer = this.freeBufferQueue.poll();
            buffer.write(data, 0, len);
            boolean added = this.receiveQueue.offer(buffer);
            if (!added) {
                this.logger.error("The message was not added to the receive queue: {}", ByteUtils.bytesToHex(buffer.toByteArray()));
            }
            this.loggerRAW.info("<< Offered to receive queue: {}", len);
        }
        catch (Exception ex) {
            this.logger.warn("Add buffer to receive queue failed. Current data: {}, len: {}", ByteUtils.bytesToHex(data), len, ex);
        }
    }

    private void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        this.logger.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", this.receiveQueueWorker);
        if (this.receiveQueueWorker != null) {
            throw new InvalidConfigurationException("The receiveQueueWorker is running already. Check your configuration!");
        }
        this.receiveQueueWorker = new Thread(() -> {
            try {
                this.processReceiveQueue();
            }
            catch (Exception ex) {
                this.logger.warn("The processing of the receive queue was terminated with an exception!", ex);
            }
            this.logger.info("Process receive queue has finished.", new Object[0]);
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorker.setPriority(8);
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            this.logger.error("Start the receiveQueueWorker failed.", ex);
        }
    }

    private void stopReceiveQueueWorker() {
        this.logger.info("Stop the receive queue worker.", new Object[0]);
        this.receiverRunning.set(false);
        if (this.receiveQueueWorker != null) {
            if (Thread.currentThread().equals(this.receiveQueueWorker)) {
                this.terminateQueueWorkers.schedule(() -> {
                    this.logger.info("Terminate the receive queue from scheduled thread.", new Object[0]);
                    this.doTerminateReceiveQueue();
                }, 10L, TimeUnit.MILLISECONDS);
            } else {
                this.logger.info("Terminate the receive queue.", new Object[0]);
                this.doTerminateReceiveQueue();
            }
        } else {
            this.logger.info("No receiveQueueWorker to stop assigned.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTerminateReceiveQueue() {
        Object object = this.receiveQueueTerminateLock;
        synchronized (object) {
            if (this.receiveQueueWorker == null) {
                this.logger.info("Skip stop receive queue because it's terminated already.", new Object[0]);
                return;
            }
            try {
                this.receiveQueueWorker.interrupt();
                this.logger.info("Wait for termination of receiveQueue worker.", new Object[0]);
                this.receiveQueueTerminateLock.wait(1000L);
                this.receiveQueueWorker.join(1000L);
                this.logger.info("receiveQueueWorker has finished.", new Object[0]);
            }
            catch (Exception ex) {
                this.logger.warn("Interrupt receiveQueueWorker failed.", ex);
            }
            this.receiveQueueWorker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReceiveQueue() {
        Object object;
        this.logger.info("The receiveQueueWorker is ready for processing.", new Object[0]);
        MR messageReceiver = this.getMessageReceiver();
        while (this.receiverRunning.get()) {
            block17: {
                ByteArrayOutputStream data = null;
                try {
                    data = this.receiveQueue.take();
                    if (data == null) break block17;
                    try {
                        this.fireReceiveStarted();
                        messageReceiver.receive(data);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Process received bytes failed.", ex);
                    }
                    finally {
                        this.fireReceiveStopped();
                    }
                }
                catch (InterruptedException ex) {
                    this.logger.info("Get message from receiveQueue failed because thread was interrupted.", new Object[0]);
                    Thread.interrupted();
                }
                catch (Exception ex) {
                    this.logger.warn("Get message from receiveQueue failed.", ex);
                }
                finally {
                    if (data != null) {
                        data.reset();
                        this.freeBufferQueue.add(data);
                    }
                }
            }
            object = null;
        }
        this.logger.info("The receiveQueueWorker has finished processing.", new Object[0]);
        this.receiveQueueWorkerThreadId.set(0L);
        object = this.receiveQueueTerminateLock;
        synchronized (object) {
            this.receiveQueueTerminateLock.notifyAll();
        }
    }

    @Override
    public void open(String portName, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        this.logger.info("Open will start the receiver and queues.", new Object[0]);
        this.startReceiverAndQueues(null, context);
    }

    @Override
    public boolean isOpened() {
        return false;
    }

    @Override
    public boolean close() {
        this.logger.info("Close port.", new Object[0]);
        this.stopReceiverAndQueues(null);
        this.firstPacketSent = false;
        return false;
    }

    private void fireSendStarted() {
        if (this.dataTransferStatusListener != null) {
            this.dataTransferStatusListener.notifySendStarted();
        }
    }

    private void fireSendStopped() {
        if (this.dataTransferStatusListener != null) {
            this.dataTransferStatusListener.notifySendStopped();
        }
    }

    private void fireReceiveStarted() {
        if (this.dataTransferStatusListener != null) {
            this.dataTransferStatusListener.notifyReceiveStarted();
        }
    }

    private void fireReceiveStopped() {
        if (this.dataTransferStatusListener != null) {
            this.dataTransferStatusListener.notifyReceiveStopped();
        }
    }

    protected void fireConnectionOpened() {
        if (this.connectionStatusListener != null) {
            this.connectionStatusListener.notifyOpened();
        }
    }

    protected void fireConnectionClosed() {
        if (this.connectionStatusListener != null) {
            this.connectionStatusListener.notifyClosed();
        }
    }
}

