/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.base;

import java.io.IOException;
import java.io.OutputStream;

public class ThrottledOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private final long maxBytesPerSecond;
    private final long startTime = System.nanoTime();
    private long bytesWrite = 0L;
    private long totalSleepTime = 0L;
    private static final long SLEEP_DURATION_MS = 30L;

    public ThrottledOutputStream(OutputStream outputStream) {
        this(outputStream, Long.MAX_VALUE);
    }

    public ThrottledOutputStream(OutputStream outputStream, long maxBytesPerSecond) {
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream shouldn't be null");
        }
        if (maxBytesPerSecond <= 0L) {
            throw new IllegalArgumentException("maxBytesPerSecond should be greater than zero");
        }
        this.outputStream = outputStream;
        this.maxBytesPerSecond = maxBytesPerSecond;
    }

    @Override
    public void write(int data) throws IOException {
        this.throttle();
        this.outputStream.write(data);
        ++this.bytesWrite;
    }

    @Override
    public void write(byte[] data, int off, int len) throws IOException {
        if ((long)len < this.maxBytesPerSecond) {
            this.throttle();
            this.bytesWrite += (long)len;
            this.outputStream.write(data, off, len);
            return;
        }
        long currentOffSet = off;
        long remainingBytesToWrite = len;
        do {
            this.throttle();
            this.bytesWrite += this.maxBytesPerSecond;
            this.outputStream.write(data, (int)currentOffSet, (int)this.maxBytesPerSecond);
            currentOffSet += this.maxBytesPerSecond;
        } while ((remainingBytesToWrite -= this.maxBytesPerSecond) > this.maxBytesPerSecond);
        this.throttle();
        this.bytesWrite += remainingBytesToWrite;
        this.outputStream.write(data, (int)currentOffSet, (int)remainingBytesToWrite);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void throttle() throws IOException {
        while (this.getBytesPerSec() > this.maxBytesPerSecond) {
            try {
                Thread.sleep(30L);
                this.totalSleepTime += 30L;
            }
            catch (InterruptedException e) {
                System.out.println("Thread interrupted" + e.getMessage());
                throw new IOException("Thread interrupted", e);
            }
        }
    }

    public long getBytesPerSec() {
        long elapsed = (System.nanoTime() - this.startTime) / 1000000000L;
        if (elapsed == 0L) {
            return this.bytesWrite;
        }
        return this.bytesWrite / elapsed;
    }

    public String toString() {
        return "ThrottledOutputStream{bytesWrite=" + this.bytesWrite + ", maxBytesPerSecond=" + this.maxBytesPerSecond + ", bytesPerSec=" + this.getBytesPerSec() + ", totalSleepTimeInSeconds=" + this.totalSleepTime / 1000L + "}";
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

