/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum AccessoryStateOptionsKeys implements BidibEnum
{
    STATE_OPTION_CURRENT_ANGLE(1),
    STATE_OPTION_TARGET_ANGLE(2);

    private final byte type;

    private AccessoryStateOptionsKeys(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static AccessoryStateOptionsKeys valueOf(byte type) {
        AccessoryStateOptionsKeys result = null;
        for (AccessoryStateOptionsKeys e : AccessoryStateOptionsKeys.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map value '0x" + ByteUtils.byteToHex(type) + "' to an accessory state options key.");
        }
        return result;
    }
}

