/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum BacklightPortEnum implements BidibEnum
{
    START(0),
    UNKNOWN(ByteUtils.getLowByte(255));

    private final byte type;

    private BacklightPortEnum(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static BacklightPortEnum valueOf(byte type) {
        BacklightPortEnum result = null;
        for (BacklightPortEnum e : BacklightPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a backlight port enum");
        }
        return result;
    }
}

