/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum BoosterControl implements BidibEnum
{
    CONNECT(0),
    LOCAL(1),
    NONE(255);

    private final byte type;

    private BoosterControl(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static BoosterControl valueOf(byte type) {
        BoosterControl result = null;
        for (BoosterControl e : BoosterControl.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a booster control");
        }
        return result;
    }
}

