/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum BoosterState implements BidibEnum
{
    OFF(0),
    OFF_SHORT(1),
    OFF_HOT(2),
    OFF_NO_POWER(3),
    OFF_GO_REQ(4),
    OFF_HERE(5),
    OFF_NO_DCC(6),
    ON(128),
    ON_LIMIT(129),
    ON_HOT(130),
    ON_STOP_REQ(131),
    ON_HERE(132);

    private final byte type;

    private BoosterState(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static BoosterState valueOf(byte type) {
        BoosterState result = null;
        for (BoosterState e : BoosterState.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a booster status");
        }
        return result;
    }

    public static boolean isOnState(BoosterState boosterState) {
        return (ByteUtils.getInt(boosterState.getType()) & 0x80) == 128;
    }

    public static boolean isOffState(BoosterState boosterState) {
        return (ByteUtils.getInt(boosterState.getType()) & 0x80) == 0;
    }
}

