/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;

public enum CommandStationState implements BidibEnum
{
    OFF(0),
    STOP(1),
    SOFTSTOP(2),
    GO(3),
    PROG(8),
    PROGBUSY(9),
    BUSY(13),
    QUERY(255),
    GO_IGN_WD(4);

    private final byte type;

    private CommandStationState(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static CommandStationState valueOf(byte type) {
        CommandStationState result = null;
        for (CommandStationState e : CommandStationState.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map " + type + " to a command station state.");
        }
        return result;
    }

    public static boolean isOnState(CommandStationState commandStationState) {
        return !CommandStationState.isPtProgState(commandStationState) && !CommandStationState.isOffState(commandStationState);
    }

    public static boolean isOffState(CommandStationState commandStationState) {
        if (commandStationState == null) {
            return true;
        }
        boolean isOffState = false;
        switch (commandStationState) {
            case OFF: 
            case STOP: 
            case SOFTSTOP: {
                isOffState = true;
                break;
            }
        }
        return isOffState;
    }

    public static boolean isPtProgState(CommandStationState commandStationState) {
        boolean isPtProgState = false;
        switch (commandStationState) {
            case PROG: 
            case PROGBUSY: {
                isPtProgState = true;
                break;
            }
        }
        return isPtProgState;
    }
}

