/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum CsQueryTypeEnum {
    LOCO_LIST("locoList", 1),
    ACCESSORY_LIST("accessoryList", 16),
    EXT_ACCESSORY_LIST("extAccessoryList", 17);

    private final byte type;
    private final String key;

    private CsQueryTypeEnum(String key, int type) {
        this.key = key;
        this.type = ByteUtils.getLowByte(type);
    }

    public String getKey() {
        return this.key;
    }

    public byte getType() {
        return this.type;
    }

    public static CsQueryTypeEnum valueOf(byte type) {
        CsQueryTypeEnum result = null;
        for (CsQueryTypeEnum e : CsQueryTypeEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a command station query type");
        }
        return result;
    }
}

