/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum CurveFormEnum implements BidibEnum
{
    LIN(0, "lin"),
    SMOOTH(1, "smooth"),
    SEESAW(2, "seesaw"),
    REBOUNCE(3, "rebounce"),
    FULL_USER_DEFINED_1(14, "full-user-defined-1"),
    FULL_USER_DEFINED_2(15, "full-user-defined-2");

    private final byte type;
    private final String key;

    private CurveFormEnum(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public static CurveFormEnum valueOf(byte type) {
        CurveFormEnum result = null;
        for (CurveFormEnum e : CurveFormEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a curveForm enum");
        }
        return result;
    }

    public static CurveFormEnum valueOf(int intType) {
        CurveFormEnum result = null;
        byte type = ByteUtils.getLowByte(intType);
        for (CurveFormEnum e : CurveFormEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a curveForm enum");
        }
        return result;
    }

    public static CurveFormEnum[] getValues() {
        return CurveFormEnum.values();
    }
}

