/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum DccAOpCodeBm implements BidibEnum
{
    BIDIB_DCCA_LOGON_COLLISION(128, "dcca-logon-collision"),
    BIDIB_DCCA_LOGON_NEW_DID(129, "dcca-logon-new-did"),
    BIDIB_DCCA_LOGON_ASSIGN_ACK(130, "dcca-logon-assign-ack"),
    BIDIB_DCCA_INFO_SHORTINFO(144, "dcca-info-shortinfo"),
    BIDIB_DCCA_INFO_SHORTGUI(145, "dcca-info-shortgui"),
    BIDIB_DCCA_INFO_FIRMWAREID(146, "dcca-info-firmwareid"),
    BIDIB_DCCA_INFO_PRODUCTNAME(147, "dcca-info-productname"),
    BIDIB_DCCA_INFO_SHORTNAME(148, "dcca-info-shortname"),
    BIDIB_DCCA_INFO_FULLNAME(149, "dcca-info-fullname"),
    BIDIB_DCCA_INFO_FUNCMAP(155, "dcca-info-funcmap"),
    BIDIB_DCCA_INFO_RAILCOM(156, "dcca-info-railcompage"),
    BIDIB_DCCA_INFO_PICTURE(157, "dcca-info-picture"),
    BIDIB_DCCA_INFO_CV_P0(158, "dcca-info-cv"),
    BIDIB_DCCA_INFO_CV_P1(159, "dcca-info-cv");

    private final String key;
    private final byte type;

    private DccAOpCodeBm(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static DccAOpCodeBm valueOf(byte type) {
        DccAOpCodeBm result = null;
        for (DccAOpCodeBm e : DccAOpCodeBm.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a DCCA opcode bm");
        }
        return result;
    }
}

