/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum DccAdvOpCodes implements BidibEnum
{
    BIDIB_DCCA_GET_TID(48, "get-tid"),
    BIDIB_DCCA_SET_TID(49, "set-tid"),
    BIDIB_DCCA_SELECT_INFO(16, "get-info"),
    BIDIB_DCCA_GET_DATA(15, "get-data"),
    BIDIB_DCCA_LOGON_ASSIGN(8, "logon-assign"),
    BIDIB_DCCA_LOGON_ENABLE_ALL(0, "logon-enable-all"),
    BIDIB_DCCA_LOGON_ENABLE_LOCO(1, "logon-enable-loco"),
    BIDIB_DCCA_LOGON_ENABLE_ACC(2, "logon-enable-acc"),
    BIDIB_DCCA_LOGON_ENABLE_NOW(3, "logon-enable-now");

    private final String key;
    private final byte type;

    private DccAdvOpCodes(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static DccAdvOpCodes valueOf(byte type) {
        DccAdvOpCodes result = null;
        for (DccAdvOpCodes e : DccAdvOpCodes.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a DCC Adv opcode");
        }
        return result;
    }
}

