/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum DirectionEnum implements BidibEnum
{
    FORWARD(128),
    BACKWARD(0);

    private byte type;

    private DirectionEnum(int value) {
        this.type = ByteUtils.getLowByte(value);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public int getValue() {
        return ByteUtils.getInt(this.type);
    }

    public static DirectionEnum valueOf(int type) {
        return DirectionEnum.valueOf(ByteUtils.getLowByte(type));
    }

    public static DirectionEnum valueOf(byte type) {
        DirectionEnum result = null;
        for (DirectionEnum e : DirectionEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a direction enum");
        }
        return result;
    }
}

