/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum DriveAcknowledge implements BidibEnum
{
    NOT_ACKNOWLEDGED(0),
    ACKNOWLEDGED(1),
    DELAYED(2);

    private final byte type;

    private DriveAcknowledge(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static DriveAcknowledge valueOf(byte type) {
        DriveAcknowledge result = null;
        for (DriveAcknowledge e : DriveAcknowledge.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a drive acknowledge");
        }
        return result;
    }
}

