/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum ErrorCodeEnum implements BidibEnum
{
    BIDIB_ERR_LC_PORT_NONE(0),
    BIDIB_ERR_LC_PORT_GENERAL(1),
    BIDIB_ERR_LC_PORT_UNKNOWN(2),
    BIDIB_ERR_LC_PORT_INACTIVE(3),
    BIDIB_ERR_LC_PORT_EXEC(4),
    BIDIB_ERR_LC_PORT_BROKEN(127);

    private final byte type;

    private ErrorCodeEnum(byte type) {
        this.type = type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static ErrorCodeEnum valueOf(byte type) {
        ErrorCodeEnum result = null;
        for (ErrorCodeEnum e : ErrorCodeEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a error code.");
        }
        return result;
    }

    public static String formatErrorCode(Integer error) {
        if (error != null) {
            byte type = ByteUtils.getLowByte(error);
            try {
                ErrorCodeEnum errorCode = ErrorCodeEnum.valueOf(type);
                String formatedErrorCode = errorCode.name();
                return formatedErrorCode;
            }
            catch (Exception ex) {
                return "n/a";
            }
        }
        return null;
    }
}

