/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum FeatureEnum implements BidibEnum
{
    FEATURE_BM_SIZE(0, 0, 128),
    FEATURE_BM_ON(1, 0, 1),
    FEATURE_BM_SECACK_AVAILABLE(2, 0, 1),
    FEATURE_BM_SECACK_ON(3, 0, 255),
    FEATURE_BM_CURMEAS_AVAILABLE(4, 0, 1),
    FEATURE_BM_CURMEAS_INTERVAL(5, 0, null),
    FEATURE_BM_DC_MEAS_AVAILABLE(6, 0, 1),
    FEATURE_BM_DC_MEAS_ON(7, 0, 1),
    FEATURE_BM_ADDR_DETECT_AVAILABLE(8, 0, 1),
    FEATURE_BM_ADDR_DETECT_ON(9, 0, 1),
    FEATURE_BM_ADDR_AND_DIR(10, 0, 1),
    FEATURE_BM_ISTSPEED_AVAILABLE(11, 0, 1),
    FEATURE_BM_ISTSPEED_INTERVAL(12, 0, 255),
    FEATURE_BM_CV_AVAILABLE(13, 0, 1),
    FEATURE_BM_CV_ON(14, 0, 1),
    FEATURE_BM_DYN_STATE_INTERVAL(28, 0, 255),
    FEATURE_BM_EXT_AVAILABLE(29, 0, 31),
    FEATURE_BM_TIMESTAMP_ON(30, 0, 1),
    FEATURE_BM_POSITION_ON(31, 0, 1),
    FEATURE_BM_POSITION_SECACK(32, 0, 255),
    FEATURE_BST_VOLT_ADJUSTABLE(15, 0, 1),
    FEATURE_BST_VOLT(16, 0, 250),
    FEATURE_BST_CUTOUT_AVAIALABLE(17),
    FEATURE_BST_CUTOUT_ON(18, 0, 1),
    FEATURE_BST_TURNOFF_TIME(19),
    FEATURE_BST_INRUSH_TURNOFF_TIME(20),
    FEATURE_BST_AMPERE_ADJUSTABLE(21, 0, 1),
    FEATURE_BST_AMPERE(22, 0, 250),
    FEATURE_BST_CURMEAS_INTERVAL(23, 0, 250),
    FEATURE_BST_CV_AVAILABLE(24),
    FEATURE_BST_CV_ON(25),
    FEATURE_BST_INHIBIT_AUTOSTART(26, 0, 1),
    FEATURE_BST_INHIBIT_LOCAL_ONOFF(27, 0, 1),
    FEATURE_ACCESSORY_COUNT(40, 0, 127),
    FEATURE_ACCESSORY_SURVEILLED(41, 0, 1),
    FEATURE_ACCESSORY_MACROMAPPED(42),
    FEATURE_GEN_SPYMODE(100, 0, 1),
    FEATURE_GEN_WATCHDOG(101, 0, 100),
    FEATURE_GEN_DRIVE_ACK(102, 0, 2),
    FEATURE_GEN_SWITCH_ACK(103, 0, 3),
    FEATURE_GEN_LOK_DB_SIZE(104),
    FEATURE_GEN_LOK_DB_STRING(105),
    FEATURE_GEN_POM_REPEAT(106, 1, 10),
    FEATURE_GEN_DRIVE_BUS(107, 0, 1),
    FEATURE_GEN_LOK_LOST_DETECT(108, 0, 1),
    FEATURE_GEN_NOTIFY_DRIVE_MANUAL(109, 0, 1),
    FEATURE_GEN_START_STATE(110, 0, 1),
    FEATURE_GEN_EXT_AVAILABLE(111, 0, 31),
    FEATURE_CELL_NUMBER(112, 0, 8),
    FEATURE_GEN_RF_CHANNEL(113, 0, 83),
    FEATURE_GEN_EXT_ENABLED(114, 0, 7),
    FEATURE_FW_UPDATE_MODE(254),
    FEATURE_RELEVANT_PID_BITS(253, 0, 31),
    FEATURE_STRING_NAMESPACES_AVAILABLE(250, 0, 255),
    FEATURE_STRING_DEBUG(251, 0, 1),
    FEATURE_STRING_SIZE(252, 0, 24),
    FEATURE_CTRL_INPUT_COUNT(50, 0, 127),
    FEATURE_CTRL_INPUT_NOTIFY(51, 0, 1),
    FEATURE_CTRL_SWITCH_COUNT(52, 0, 127),
    FEATURE_CTRL_LIGHT_COUNT(53, 0, 127),
    FEATURE_CTRL_SERVO_COUNT(54, 0, 127),
    FEATURE_CTRL_SOUND_COUNT(55, 0, 127),
    FEATURE_CTRL_MOTOR_COUNT(56, 0, 127),
    FEATURE_CTRL_ANALOGOUT_COUNT(57, 0, 127),
    FEATURE_CTRL_STRETCH_DIMM(58, 1, 250),
    FEATURE_CTRL_BACKLIGHT_COUNT(59),
    FEATURE_CTRL_MAC_LEVEL(60, 0, 2),
    FEATURE_CTRL_MAC_SAVE(61),
    FEATURE_CTRL_MAC_SIZE(63),
    FEATURE_CTRL_MAC_COUNT(62),
    FEATURE_CTRL_MAC_START_DCC(65, 0, 1),
    FEATURE_CTRL_MAC_START_MAN(64, 0, 1),
    FEATURE_CTRL_PORT_QUERY_AVAILABLE(66, 0, 1),
    FEATURE_SWITCH_CONFIG_AVAILABLE(67, 0, 1),
    FEATURE_CTRL_PORT_FLAT_MODEL(70, 0, 127),
    FEATURE_CTRL_PORT_FLAT_MODEL_EXTENDED(71, 0, 255);

    public static final int FEATUREMASK_STRINGNAMESPACESAVAILABLE = 4;
    private final byte type;
    private final Integer min;
    private final Integer max;

    private FeatureEnum(int type) {
        this(type, null, null);
    }

    private FeatureEnum(int type, Integer min, Integer max) {
        this.type = ByteUtils.getLowByte(type);
        this.min = min;
        this.max = max;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public int getNumber() {
        return ByteUtils.getInt(this.type);
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }

    public static FeatureEnum valueOf(byte type) {
        FeatureEnum result = null;
        for (FeatureEnum e : FeatureEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a feature.");
        }
        return result;
    }
}

