/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum InputPortEnum implements BidibEnum
{
    OFF(0),
    ON(1);

    private final byte type;

    private InputPortEnum(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static InputPortEnum valueOf(byte type) {
        InputPortEnum result = null;
        for (InputPortEnum e : InputPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map 0x" + ByteUtils.byteToHex(type) + " to an input port enum");
        }
        return result;
    }
}

