/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum IoBehaviourInputEnum implements BidibEnum
{
    ACTIVE_LOW(0, "active_low"),
    ACTIVE_HIGH(1, "active_high"),
    ACTIVE_LOW_PULLUP(2, "active_low_pullup"),
    ACTIVE_HIGH_PULLDOWN(3, "active_high_pulldown"),
    UNKNOWN(255, "unknown");

    private final byte type;
    private final String key;

    private IoBehaviourInputEnum(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public static IoBehaviourInputEnum valueOf(byte type) {
        IoBehaviourInputEnum result = null;
        for (IoBehaviourInputEnum e : IoBehaviourInputEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a io behaviour input enum");
        }
        return result;
    }

    public static IoBehaviourInputEnum[] getValues() {
        return IoBehaviourInputEnum.values();
    }
}

