/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum IoBehaviourSwitchEnum implements BidibEnum
{
    LOW(0, "low"),
    HIGH(1, "high"),
    Z(2, "z"),
    WEAK_LOW(3, "weakLow"),
    WEAK_HIGH(4, "weakHigh"),
    UNKNOWN(255, "unknown");

    private final byte type;
    private final String key;

    private IoBehaviourSwitchEnum(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public static IoBehaviourSwitchEnum valueOf(byte type) {
        IoBehaviourSwitchEnum result = null;
        for (IoBehaviourSwitchEnum e : IoBehaviourSwitchEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a io behaviour switch enum");
        }
        return result;
    }

    public static IoBehaviourSwitchEnum[] getValues() {
        return IoBehaviourSwitchEnum.values();
    }
}

