/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.enums.PortStatusAware;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum LcOutputType implements BidibEnum,
PortStatusAware
{
    SWITCHPORT(0, true, "switch"),
    LIGHTPORT(1, true, "light"),
    SERVOPORT(2, true, "servo"),
    SOUNDPORT(3, true, "sound"),
    MOTORPORT(4, true, "motor"),
    ANALOGPORT(5, true, "analogout"),
    BACKLIGHTPORT(6, true, "backlight"),
    SWITCHPAIRPORT(7, true, "switchpair"),
    INPUTPORT(15, true, "input"),
    DELAY_FIXED(244),
    RANDOM_DELAY(245),
    INPUT_QUERY0(246),
    INPUT_QUERY1(247),
    FLAG_CLEAR(248),
    FLAG_SET(249),
    FLAG_QUERY(250),
    FLAG_QUERY1(250),
    FLAG_QUERY0(239),
    END_CRITICAL(251),
    BEGIN_CRITICAL(252),
    STOP_MACRO(253),
    START_MACRO(254),
    END_OF_MACRO(255),
    WAIT_FOR_END_OF_MACRO(238),
    ACCESSORY_OKAY_INPUTQUERY0(242),
    ACCESSORY_OKAY_INPUTQUERY1(243),
    ACCESSORY_OKAY_NF(241),
    SERVOMOVE_QUERY(240),
    FEEDBACKPORT(255, true, "feedback");

    private final byte type;
    private final boolean hasPortStatus;
    private final String key;

    private LcOutputType(int type) {
        this(type, false, null);
    }

    private LcOutputType(int type, boolean hasPortStatus, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.hasPortStatus = hasPortStatus;
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public boolean hasPortStatus() {
        return this.hasPortStatus;
    }

    public String getKey() {
        return this.key;
    }

    public static LcOutputType valueOf(byte type) {
        LcOutputType result = null;
        for (LcOutputType e : LcOutputType.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map value " + (type & 0xFF) + " (0x" + ByteUtils.byteToHex(type) + ") to an output type");
        }
        return result;
    }
}

