/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum LightPortEnum implements BidibEnum
{
    ON(1),
    OFF(0),
    UP(3),
    DOWN(2),
    NEON(4),
    BLINKA(5),
    BLINKB(6),
    FLASHA(7),
    FLASHB(8),
    DOUBLEFLASH(9),
    TEST(ByteUtils.getLowByte(254)),
    UNKNOWN(ByteUtils.getLowByte(255));

    private final byte type;

    private LightPortEnum(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static LightPortEnum valueOf(byte type) {
        LightPortEnum result = null;
        for (LightPortEnum e : LightPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a light port enum");
        }
        return result;
    }
}

