/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum LinkDescriptorEnum implements BidibEnum
{
    BIDIB_LINK_DESCRIPTOR_PROD_STRING(0),
    BIDIB_LINK_DESCRIPTOR_USER_STRING(1),
    BIDIB_LINK_DESCRIPTOR_P_VERSION(128),
    BIDIB_LINK_DESCRIPTOR_ROLE(127),
    BIDIB_LINK_PAIRING_REQUEST(252),
    BIDIB_LINK_STATUS_UNPAIRED(253),
    BIDIB_LINK_STATUS_PAIRED(254),
    BIDIB_LINK_DESCRIPTOR_UID(255);

    private final int type;

    private LinkDescriptorEnum(int type) {
        this.type = type;
    }

    @Override
    public byte getType() {
        return (byte)(this.type & 0xFF);
    }

    public static LinkDescriptorEnum valueOf(byte type) {
        LinkDescriptorEnum result = null;
        int typeVal = ByteUtils.getInt(type);
        for (LinkDescriptorEnum e : LinkDescriptorEnum.values()) {
            if (e.type != typeVal) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + typeVal + " to a link descriptor enum");
        }
        return result;
    }

    public static LinkDescriptorEnum valueOf(int type) {
        LinkDescriptorEnum result = null;
        for (LinkDescriptorEnum e : LinkDescriptorEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a link descriptor enum");
        }
        return result;
    }
}

