/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum LoadTypeEnum implements BidibEnum
{
    SWICH_ONLY(0, "switchOnly"),
    RESISTIVE(1, "resistive"),
    MAG_COIL_NO_LIMITSTOP(2, "magCoilNoLimitStop"),
    MAG_COIL_WITH_LIMITSTOP(3, "magCoilWithLimitStop"),
    UNKNOWN(255, "unknown");

    private final byte type;
    private final String key;

    private LoadTypeEnum(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public static LoadTypeEnum valueOf(byte type) {
        LoadTypeEnum result = null;
        for (LoadTypeEnum e : LoadTypeEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a load type enum");
        }
        return result;
    }

    public static LoadTypeEnum[] getValues() {
        return LoadTypeEnum.values();
    }
}

