/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum M4OpCodes implements BidibEnum
{
    M4_GET_TID(0, "get-tid"),
    M4_SET_TID(1, "set-tid"),
    M4_SET_BEACON(2, "set-beacon"),
    M4_SET_SEARCH(3, "set-search"),
    M4_BIND_ADDR(4, "bind-addr"),
    M4_UNBIND_ADDR(5, "unbind-address");

    private final String key;
    private final byte type;

    private M4OpCodes(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static M4OpCodes valueOf(byte type) {
        M4OpCodes result = null;
        for (M4OpCodes e : M4OpCodes.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a M4 opcode");
        }
        return result;
    }
}

