/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum M4OpCodesAck implements BidibEnum
{
    M4_TID(128, "tid"),
    M4_BEACON(130, "beacon"),
    M4_SEARCH(131, "search"),
    M4_BIND_ADDR_ACK(132, "bind-addr-ack"),
    M4_UNBIND_ADDR_ACK(133, "unbind-addr-ack"),
    M4_NEW_LOCO(134, "new-loco"),
    M4_PING_OKAY(135, "ping-ok"),
    M4_SEARCH_ACK(136, "search-ack");

    private final String key;
    private final byte type;

    private M4OpCodesAck(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static M4OpCodesAck valueOf(byte type) {
        M4OpCodesAck result = null;
        for (M4OpCodesAck e : M4OpCodesAck.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a M4 opcode");
        }
        return result;
    }
}

