/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import java.util.LinkedHashSet;
import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum MessageClassEnum implements BidibEnum
{
    BIDIB_MESSAGE_CLASS_NOTHING(0, 0),
    BIDIB_MESSAGE_CLASS_SYSTEM(1, 0),
    BIDIB_MESSAGE_CLASS_FEATURE_AND_USER(2, 1),
    BIDIB_MESSAGE_CLASS_FEEDBACK(4, 2),
    BIDIB_MESSAGE_CLASS_BOOSTER(8, 3),
    BIDIB_MESSAGE_CLASS_PORT_AND_MACRO(16, 4),
    BIDIB_MESSAGE_CLASS_GUEST_AND_HUB(32, 5),
    BIDIB_MESSAGE_CLASS_COMMANDSTATION(64, 6),
    BIDIB_MESSAGE_CLASS_ACCESSORY(128, 7);

    private final int type;
    private final int bitNum;

    private MessageClassEnum(int type, int bitNum) {
        this.type = type;
        this.bitNum = bitNum;
    }

    @Override
    public byte getType() {
        return ByteUtils.getLowByte(this.type);
    }

    public int getTypeValue() {
        return this.type;
    }

    public static int classValue(MessageClassEnum messageClassEnum) {
        return messageClassEnum.getType();
    }

    public static MessageClassEnum[] valuesOf(int type) {
        LinkedHashSet<MessageClassEnum> result = new LinkedHashSet<MessageClassEnum>();
        for (MessageClassEnum e : MessageClassEnum.values()) {
            if (e == BIDIB_MESSAGE_CLASS_NOTHING || (type & e.type) != e.type && (type >> 8 & e.type) != e.type) continue;
            result.add(e);
        }
        return result.toArray(new MessageClassEnum[0]);
    }

    public static boolean isAnyActive(MessageClassEnum messageClass, int value) {
        if (messageClass == BIDIB_MESSAGE_CLASS_NOTHING) {
            return value == 0;
        }
        if ((value & messageClass.type) >> messageClass.bitNum == 1) {
            return true;
        }
        return (value >> 8 & messageClass.type) >> messageClass.bitNum == 1;
    }

    public static boolean isDownstreamActive(MessageClassEnum messageClass, int value) {
        if (messageClass == BIDIB_MESSAGE_CLASS_NOTHING) {
            return value == 0;
        }
        return (value & messageClass.type) >> messageClass.bitNum == 1;
    }

    public static boolean isUpstreamActive(MessageClassEnum messageClass, int value) {
        if (messageClass == BIDIB_MESSAGE_CLASS_NOTHING) {
            return value == 0;
        }
        return (value >> 8 & messageClass.type) >> messageClass.bitNum == 1;
    }
}

