/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum MotorPortEnum implements BidibEnum
{
    FORWARD(0),
    BACKWARD(1),
    TEST(ByteUtils.getLowByte(255));

    private final byte type;

    private MotorPortEnum(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static MotorPortEnum valueOf(byte type) {
        MotorPortEnum result = null;
        for (MotorPortEnum e : MotorPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a motor port enum");
        }
        return result;
    }
}

