/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum NetBidibRole implements BidibEnum
{
    INTERFACE("interface", 1),
    NODE("node", 2),
    BOTH("both", 3);

    private final int type;
    private final String key;

    private NetBidibRole(String key, int type) {
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return ByteUtils.getLowByte(this.type);
    }

    public static NetBidibRole valueOf(int type) {
        NetBidibRole result = null;
        for (NetBidibRole e : NetBidibRole.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a NetBidibRole enum");
        }
        return result;
    }
}

