/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import java.util.Set;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum PortConfigKeys implements BidibEnum
{
    BIDIB_PCFG_NONE(0),
    BIDIB_PCFG_LEVEL_PORT_ON(1),
    BIDIB_PCFG_LEVEL_PORT_OFF(2),
    BIDIB_PCFG_DIMM_UP(3),
    BIDIB_PCFG_DIMM_DOWN(4),
    BIDIB_PCFG_OUTPUT_MAP(6),
    BIDIB_PCFG_SERVO_ADJ_L(7),
    BIDIB_PCFG_SERVO_ADJ_H(8),
    BIDIB_PCFG_SERVO_SPEED(9),
    BIDIB_PCFG_DIMM_UP_8_8(67),
    BIDIB_PCFG_DIMM_DOWN_8_8(68),
    BIDIB_PCFG_RGB(-128),
    BIDIB_PCFG_CONTINUE(-1),
    BIDIB_PCFG_RECONFIG(-127),
    BIDIB_PCFG_TICKS(11),
    BIDIB_PCFG_SWITCH_CTRL(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL),
    BIDIB_PCFG_INPUT_CTRL(BidibLibrary.BIDIB_PCFG_INPUT_CTRL),
    BIDIB_PCFG_TRANSITION_TIME(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME),
    BIDIB_PCFG_LOAD_TYPE(BidibLibrary.BIDIB_PCFG_LOAD_TYPE),
    BIDIB_PCFG_MOVE_TYPE(16),
    BIDIB_PCFG_SERVO_EXTRA(10);

    private final byte type;

    private PortConfigKeys(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static PortConfigKeys valueOf(byte type) {
        PortConfigKeys result = null;
        for (PortConfigKeys e : PortConfigKeys.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map value '0x" + ByteUtils.byteToHex(type) + "' to a port config key.");
        }
        return result;
    }

    public static PortConfigKeys[] valueOf(Set<Byte> types) {
        PortConfigKeys[] keys = new PortConfigKeys[types.size()];
        int index = 0;
        for (Byte type : types) {
            keys[index] = PortConfigKeys.valueOf(type);
            ++index;
        }
        return keys;
    }
}

