/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;

public enum PortModelEnum {
    type,
    flat,
    flat_extended;


    public static PortModelEnum getPortModel(Node node) {
        if (ProductUtils.isOneControl(node.getUniqueId()) && node.getSoftwareVersion().compareTo(SoftwareVersion.build(2, 0, 6)) < 1) {
            return type;
        }
        if (ProductUtils.isOneDriveTurn(node.getUniqueId()) && node.getSoftwareVersion().compareTo(SoftwareVersion.build(1, 1, 7)) < 1) {
            return type;
        }
        if (node.isPortFlatModelAvailable()) {
            if (node.getPortFlatModel() > 127) {
                return flat_extended;
            }
            return flat;
        }
        return type;
    }

    public static LcOutputType getPortType(PortModelEnum portModel, byte lowByte) {
        LcOutputType outputType = null;
        switch (portModel) {
            case flat_extended: 
            case flat: {
                outputType = LcOutputType.SWITCHPORT;
                break;
            }
            default: {
                outputType = LcOutputType.valueOf(lowByte);
            }
        }
        return outputType;
    }

    public static int getPortNumber(PortModelEnum portModel, byte lowByte, byte highByte) {
        int portNumber = -1;
        switch (portModel) {
            case flat_extended: {
                portNumber = ByteUtils.getInt(lowByte, highByte & 0x7F);
                break;
            }
            case flat: {
                portNumber = ByteUtils.getInt(lowByte);
                break;
            }
            default: {
                portNumber = ByteUtils.getInt(highByte, 127);
            }
        }
        return portNumber;
    }
}

