/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortStatusAware;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum PortType implements BidibEnum,
PortStatusAware
{
    ANALOGPORT(5, true, "analogout"),
    BACKLIGHTPORT(6, true, "backlight"),
    INPUTPORT(15, true, "input"),
    LIGHTPORT(1, true, "light"),
    MOTORPORT(4, true, "motor"),
    SERVOPORT(2, true, "servo"),
    SOUNDPORT(3, true, "sound"),
    SWITCHPORT(0, true, "switch"),
    SWITCHPAIRPORT(7, true, "switchpair");

    private final byte type;
    private final boolean hasPortStatus;
    private final String key;

    private PortType(int type) {
        this(type, false, null);
    }

    private PortType(int type, boolean hasPortStatus, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.hasPortStatus = hasPortStatus;
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public boolean hasPortStatus() {
        return this.hasPortStatus;
    }

    public String getKey() {
        return this.key;
    }

    public static PortType valueOf(byte type) {
        PortType result = null;
        for (PortType e : PortType.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map value " + (type & 0xFF) + " (0x" + ByteUtils.byteToHex(type) + ") to a port type");
        }
        return result;
    }

    public static PortType from(LcOutputType lcOutputType) {
        byte type = lcOutputType.getType();
        PortType result = null;
        for (PortType e : PortType.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map value " + (type & 0xFF) + " (0x" + ByteUtils.byteToHex(type) + ") to a port type");
        }
        return result;
    }
}

