/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum PositionLocationEnum implements BidibEnum
{
    LOCATOR_BADGE(0, "locatorBadge"),
    CELL_IDENTIFIER(1, "cellIdentifier"),
    RFID_READOUT(2, "rfidReadout"),
    AXLE_COUNTER(3, "axleCounter"),
    OTHER(255, "other");

    private final byte type;
    private final String key;

    private PositionLocationEnum(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public static PositionLocationEnum valueOf(byte type) {
        PositionLocationEnum result = null;
        for (PositionLocationEnum e : PositionLocationEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a io PositionLocationEnum.");
        }
        return result;
    }

    public static PositionLocationEnum[] getValues() {
        return PositionLocationEnum.values();
    }
}

