/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum RcPlusAcknowledge implements BidibEnum
{
    NOT_ACKNOWLEDGED(0),
    ACKNOWLEDGED(1),
    DELAYED(2),
    SENT_BUT_NO_RESPONSE(4),
    RECEIVED_DECODER_ACKN(5);

    private final byte type;

    private RcPlusAcknowledge(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static RcPlusAcknowledge valueOf(byte type) {
        RcPlusAcknowledge result = null;
        for (RcPlusAcknowledge e : RcPlusAcknowledge.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a RcPlus acknowledge");
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RcPlusAcknowledge,type=");
        sb.append(ByteUtils.byteToHex(this.type));
        return sb.toString();
    }
}

