/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum RcPlusOpCodeBm implements BidibEnum
{
    RC_BIND_ACCEPTED_LOCO(0, "bind-accepted-loco"),
    RC_BIND_ACCEPTED_ACCESSORY(2, "bind-accepted-accessory"),
    RC_PING_COLLISION_P0(4, "ping-collision-p0"),
    RC_PING_COLLISION_P1(5, "ping-collision-p1"),
    RC_FIND_COLLISION_P0(6, "find-collision-p0"),
    RC_FIND_COLLISION_P1(7, "find-collision-p1"),
    RC_PONG_OKAY_LOCO_P0(8, "pong-okay-loco-p0"),
    RC_PONG_OKAY_LOCO_P1(9, "pong-okay-loco-p1"),
    RC_PONG_OKAY_ACCESSORY_P0(10, "pong-okay-accessory-p0"),
    RC_PONG_OKAY_ACCESSORY_P1(11, "pong-okay-accessory-p1"),
    RC_PONG_NEW_LOCO_P0(12, "pong-new-loco-p0"),
    RC_PONG_NEW_LOCO_P1(13, "pong-new-loco-p1"),
    RC_PONG_NEW_ACCESSORY_P0(14, "pong-new-accessory-p0"),
    RC_PONG_NEW_ACCESSORY_P1(15, "pong-new-accessory-p1");

    private final String key;
    private final byte type;

    private RcPlusOpCodeBm(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static RcPlusOpCodeBm valueOf(byte type) {
        RcPlusOpCodeBm result = null;
        for (RcPlusOpCodeBm e : RcPlusOpCodeBm.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a rcplus opcode bm");
        }
        return result;
    }
}

