/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum RcPlusOpCodes implements BidibEnum
{
    RC_BIND(0, "bind"),
    RC_PING(1, "ping"),
    RC_GET_TID(2, "get-tid"),
    RC_SET_TID(3, "set-tid"),
    RC_PING_ONCE_P0(4, "ping-once-p0"),
    RC_PING_ONCE(4, "ping-once"),
    RC_PING_ONCE_P1(5, "ping-once-p1"),
    RC_FIND_P0(6, "find-p0"),
    RC_FIND_P1(7, "find-p1");

    private final String key;
    private final byte type;

    private RcPlusOpCodes(int type, String key) {
        this.type = ByteUtils.getLowByte(type);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static RcPlusOpCodes valueOf(byte type) {
        RcPlusOpCodes result = null;
        for (RcPlusOpCodes e : RcPlusOpCodes.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a rcplus opcode");
        }
        return result;
    }
}

