/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum ServoPortEnum implements BidibEnum
{
    START(ByteUtils.getLowByte(0)),
    TEST(ByteUtils.getLowByte(255));

    private final byte type;

    private ServoPortEnum(byte type) {
        this.type = type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static ServoPortEnum valueOf(byte type) {
        ServoPortEnum result = null;
        for (ServoPortEnum e : ServoPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a servo port enum");
        }
        return result;
    }
}

